/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4;

import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.http4.Http4FileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileSystem;

public final class Webdav4FileSystemConfigBuilder
extends Http4FileSystemConfigBuilder {
    protected static final String KEY_APPEND_TRAILING_SLASH = "appendTrailingSlash";
    private static final Webdav4FileSystemConfigBuilder BUILDER = new Webdav4FileSystemConfigBuilder();
    private static final boolean DEFAULT_APPEND_TRAILING_SLASH = false;
    private static final boolean DEFAULT_FOLLOW_REDIRECT = false;

    public static Webdav4FileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    private Webdav4FileSystemConfigBuilder() {
        super("webdav4.");
    }

    public boolean getAppendTrailingSlash(FileSystemOptions opts) {
        return this.getBoolean(opts, KEY_APPEND_TRAILING_SLASH, false);
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return Webdav4FileSystem.class;
    }

    public String getCreatorName(FileSystemOptions opts) {
        return this.getString(opts, "creatorName");
    }

    public boolean getFollowRedirect(FileSystemOptions opts) {
        return this.getBoolean(opts, "followRedirect", false);
    }

    public boolean isVersioning(FileSystemOptions opts) {
        return this.getBoolean(opts, "versioning", false);
    }

    public void setAppendTrailingSlash(FileSystemOptions opts, boolean appendTrailingSlash) {
        this.setParam(opts, KEY_APPEND_TRAILING_SLASH, appendTrailingSlash);
    }

    public void setCreatorName(FileSystemOptions opts, String creatorName) {
        this.setParam(opts, "creatorName", creatorName);
    }

    public void setVersioning(FileSystemOptions opts, boolean versioning) {
        this.setParam(opts, "versioning", versioning);
    }
}

