/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.theta.BitPacking;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BitPackingTest {
    private static final boolean enablePrinting = false;

    @Test
    public void packUnpackBits() {
        long value = -6172840429334713771L;
        for (int n = 0; n < 10000; ++n) {
            for (int bits = 1; bits <= 63; ++bits) {
                int i;
                long mask = (1 << bits) - 1;
                long[] input = new long[8];
                for (int i2 = 0; i2 < 8; ++i2) {
                    input[i2] = value & mask;
                    value += -7046029254386353133L;
                }
                byte[] bytes = new byte[64];
                int bitOffset = 0;
                int bufOffset = 0;
                for (int i3 = 0; i3 < 8; ++i3) {
                    BitPacking.packBits((long)input[i3], (int)bits, (byte[])bytes, (int)bufOffset, (int)bitOffset);
                    bufOffset += bitOffset + bits >>> 3;
                    bitOffset = bitOffset + bits & 7;
                }
                long[] output = new long[8];
                bitOffset = 0;
                bufOffset = 0;
                for (i = 0; i < 8; ++i) {
                    BitPacking.unpackBits((long[])output, (int)i, (int)bits, (byte[])bytes, (int)bufOffset, (int)bitOffset);
                    bufOffset += bitOffset + bits >>> 3;
                    bitOffset = bitOffset + bits & 7;
                }
                for (i = 0; i < 8; ++i) {
                    Assert.assertEquals((long)output[i], (long)input[i]);
                }
            }
        }
    }

    @Test
    public void packUnpackBlocks() {
        long value = -6172840429334713771L;
        for (int n = 0; n < 10000; ++n) {
            for (int bits = 1; bits <= 63; ++bits) {
                long mask = (1L << bits) - 1L;
                long[] input = new long[8];
                for (int i = 0; i < 8; ++i) {
                    input[i] = value & mask;
                    value += -7046029254386353133L;
                }
                byte[] bytes = new byte[64];
                BitPacking.packBitsBlock8((long[])input, (int)0, (byte[])bytes, (int)0, (int)bits);
                long[] output = new long[8];
                BitPacking.unpackBitsBlock8((long[])output, (int)0, (byte[])bytes, (int)0, (int)bits);
                for (int i = 0; i < 8; ++i) {
                    Assert.assertEquals((long)output[i], (long)input[i]);
                }
            }
        }
    }

    void hexDump(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            System.out.print(String.format("%02x ", bytes[i]));
        }
        System.out.println();
    }
}

