/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.HeapAuxHashMap;
import org.apache.datasketches.hll.PairIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuxHashMapTest {
    static final String LS = System.getProperty("line.separator");

    @Test
    public void checkMustReplace() {
        HeapAuxHashMap map = new HeapAuxHashMap(3, 7);
        map.mustAdd(100, 5);
        int val = map.mustFindValueFor(100);
        Assert.assertEquals((int)val, (int)5);
        map.mustReplace(100, 10);
        val = map.mustFindValueFor(100);
        Assert.assertEquals((int)val, (int)10);
        try {
            map.mustReplace(101, 5);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkGrowSpace() {
        HeapAuxHashMap map = new HeapAuxHashMap(3, 7);
        Assert.assertFalse((boolean)map.isMemory());
        Assert.assertFalse((boolean)map.isOffHeap());
        Assert.assertEquals((int)map.getLgAuxArrInts(), (int)3);
        for (int i = 1; i <= 7; ++i) {
            map.mustAdd(i, i);
        }
        Assert.assertEquals((int)map.getLgAuxArrInts(), (int)4);
        PairIterator itr = map.getIterator();
        int count1 = 0;
        int count2 = 0;
        while (itr.nextAll()) {
            ++count2;
            int pair = itr.getPair();
            if (pair == 0) continue;
            ++count1;
        }
        Assert.assertEquals((int)count1, (int)7);
        Assert.assertEquals((int)count2, (int)16);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkExceptions1() {
        HeapAuxHashMap map = new HeapAuxHashMap(3, 7);
        map.mustAdd(100, 5);
        map.mustFindValueFor(101);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkExceptions2() {
        HeapAuxHashMap map = new HeapAuxHashMap(3, 7);
        map.mustAdd(100, 5);
        map.mustAdd(100, 6);
    }

    @Test
    public void printlnTest() {
        AuxHashMapTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

