/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IsomorphicTest {
    long v = 0L;

    @Test
    public void isomorphicUnionUpdatableHeap() {
        for (int lgK = 4; lgK <= 21; ++lgK) {
            for (int cm = 0; cm <= 2; ++cm) {
                if (lgK < 8 && cm == 1) continue;
                CurMode curMode = CurMode.fromOrdinal((int)cm);
                for (int t = 0; t <= 2; ++t) {
                    TgtHllType tgtHllType1 = TgtHllType.fromOrdinal((int)t);
                    HllSketch sk1 = this.buildHeapSketch(lgK, tgtHllType1, curMode);
                    byte[] sk1bytes = sk1.toUpdatableByteArray();
                    Union union = this.buildHeapUnion(lgK, null);
                    union.update(sk1);
                    HllSketch sk2 = union.getResult(tgtHllType1);
                    byte[] sk2bytes = sk2.toUpdatableByteArray();
                    String comb = "LgK=" + lgK + ", CurMode=" + curMode.toString() + ", Type:" + tgtHllType1;
                    IsomorphicTest.checkArrays(sk1bytes, sk2bytes, comb, false);
                }
            }
        }
    }

    @Test
    public void isomorphicUnionCompactHeap() {
        for (int lgK = 4; lgK <= 21; ++lgK) {
            for (int cm = 0; cm <= 2; ++cm) {
                if (lgK < 8 && cm == 1) continue;
                CurMode curMode = CurMode.fromOrdinal((int)cm);
                for (int t = 0; t <= 2; ++t) {
                    TgtHllType tgtHllType1 = TgtHllType.fromOrdinal((int)t);
                    HllSketch sk1 = this.buildHeapSketch(lgK, tgtHllType1, curMode);
                    byte[] sk1bytes = sk1.toCompactByteArray();
                    Union union = this.buildHeapUnion(lgK, null);
                    union.update(sk1);
                    HllSketch sk2 = union.getResult(tgtHllType1);
                    byte[] sk2bytes = sk2.toCompactByteArray();
                    String comb = "LgK=" + lgK + ", CurMode=" + curMode.toString() + ", Type:" + tgtHllType1;
                    IsomorphicTest.checkArrays(sk1bytes, sk2bytes, comb, false);
                }
            }
        }
    }

    @Test
    public void isomorphicCopyAsUpdatableHeap() {
        for (int lgK = 4; lgK <= 21; ++lgK) {
            for (int cm = 0; cm <= 2; ++cm) {
                if (lgK < 8 && cm == 1) continue;
                CurMode curMode = CurMode.fromOrdinal((int)cm);
                for (int t1 = 0; t1 <= 2; ++t1) {
                    TgtHllType tgtHllType1 = TgtHllType.fromOrdinal((int)t1);
                    HllSketch sk1 = this.buildHeapSketch(lgK, tgtHllType1, curMode);
                    byte[] sk1bytes = sk1.toUpdatableByteArray();
                    for (int t2 = 0; t2 <= 2; ++t2) {
                        if (t2 == t1) continue;
                        TgtHllType tgtHllType2 = TgtHllType.fromOrdinal((int)t2);
                        HllSketch sk2 = sk1.copyAs(tgtHllType2);
                        HllSketch sk1B = sk2.copyAs(tgtHllType1);
                        byte[] sk1Bbytes = sk1B.toUpdatableByteArray();
                        String comb = "LgK= " + lgK + ", CurMode= " + curMode.toString() + ", Type1: " + tgtHllType1 + ", Type2: " + tgtHllType2;
                        IsomorphicTest.checkArrays(sk1bytes, sk1Bbytes, comb, false);
                    }
                }
            }
        }
    }

    @Test
    public void isomorphicCopyAsCompactHeap() {
        for (int lgK = 4; lgK <= 21; ++lgK) {
            for (int cm = 0; cm <= 2; ++cm) {
                if (lgK < 8 && cm == 1) continue;
                CurMode curMode = CurMode.fromOrdinal((int)cm);
                for (int t1 = 0; t1 <= 2; ++t1) {
                    TgtHllType tgtHllType1 = TgtHllType.fromOrdinal((int)t1);
                    HllSketch sk1 = this.buildHeapSketch(lgK, tgtHllType1, curMode);
                    byte[] sk1bytes = sk1.toCompactByteArray();
                    for (int t2 = 0; t2 <= 2; ++t2) {
                        if (t2 == t1) continue;
                        TgtHllType tgtHllType2 = TgtHllType.fromOrdinal((int)t2);
                        HllSketch sk2 = sk1.copyAs(tgtHllType2);
                        HllSketch sk3 = sk2.copyAs(tgtHllType1);
                        byte[] sk3bytes = sk3.toCompactByteArray();
                        String comb = "LgK= " + lgK + ", CurMode= " + curMode.toString() + ", Type1: " + tgtHllType1 + ", Type2: " + tgtHllType2;
                        IsomorphicTest.checkArrays(sk1bytes, sk3bytes, comb, false);
                    }
                }
            }
        }
    }

    @Test
    public void isomorphicHllMerges() {
        for (int uLgK = 4; uLgK <= 20; ++uLgK) {
            TgtHllType tgtHllType;
            int t1;
            int skLgK = uLgK;
            for (t1 = 0; t1 <= 2; ++t1) {
                tgtHllType = TgtHllType.fromOrdinal((int)t1);
                IsomorphicTest.innerLoop(uLgK, skLgK, tgtHllType);
            }
            skLgK = uLgK + 1;
            for (t1 = 0; t1 <= 2; ++t1) {
                tgtHllType = TgtHllType.fromOrdinal((int)t1);
                IsomorphicTest.innerLoop(uLgK, skLgK, tgtHllType);
            }
        }
    }

    private static void innerLoop(int uLgK, int skLgK, TgtHllType tgtHllType) {
        Union u = IsomorphicTest.buildHeapUnionHllMode(uLgK, 0);
        HllSketch sk = IsomorphicTest.buildHeapSketchHllMode(skLgK, tgtHllType, 1 << uLgK);
        u.update(sk);
        byte[] bytesOut1 = u.getResult(TgtHllType.HLL_8).toUpdatableByteArray();
        u = IsomorphicTest.buildHeapUnionHllMode(uLgK, 0);
        sk = IsomorphicTest.buildMemorySketchHllMode(skLgK, tgtHllType, 1 << uLgK);
        u.update(sk);
        byte[] bytesOut2 = u.getResult(TgtHllType.HLL_8).toUpdatableByteArray();
        String comb = "uLgK: " + uLgK + ", skLgK: " + skLgK + ", SkType: " + tgtHllType.toString() + ", Case1: Heap Union, Heap sketch; Case2: /Heap Union, Memory sketch";
        IsomorphicTest.checkArrays(bytesOut1, bytesOut2, comb, false);
        u = IsomorphicTest.buildMemoryUnionHllMode(uLgK, 0);
        sk = IsomorphicTest.buildHeapSketchHllMode(skLgK, tgtHllType, 1 << uLgK);
        u.update(sk);
        byte[] bytesOut3 = u.getResult(TgtHllType.HLL_8).toUpdatableByteArray();
        comb = "LgK: " + uLgK + ", skLgK: " + skLgK + ", SkType: " + tgtHllType.toString() + ", Case2: Heap Union, Memory sketch; Case3: /Memory Union, Heap sketch";
        IsomorphicTest.checkArrays(bytesOut2, bytesOut3, comb, false);
        u = IsomorphicTest.buildMemoryUnionHllMode(uLgK, 0);
        sk = IsomorphicTest.buildMemorySketchHllMode(skLgK, tgtHllType, 1 << uLgK);
        u.update(sk);
        byte[] bytesOut4 = u.getResult(TgtHllType.HLL_8).toUpdatableByteArray();
        comb = "LgK: " + uLgK + ", skLgK: " + skLgK + ", SkType: " + tgtHllType.toString() + ", Case2: Heap Union, Memory sketch; Case4: /Memory Union, Memory sketch";
        IsomorphicTest.checkArrays(bytesOut2, bytesOut4, comb, false);
    }

    @Test
    public void isomorphicHllMerges2() {
        for (int lgK = 4; lgK <= 4; ++lgK) {
            Union u = IsomorphicTest.buildHeapUnionHllMode(lgK, 0);
            HllSketch sk = IsomorphicTest.buildHeapSketchHllMode(lgK, TgtHllType.HLL_8, 1 << lgK);
            u.update(sk);
            byte[] bytesOut8 = u.getResult(TgtHllType.HLL_8).toUpdatableByteArray();
            u = IsomorphicTest.buildHeapUnionHllMode(lgK, 0);
            sk = IsomorphicTest.buildHeapSketchHllMode(lgK, TgtHllType.HLL_6, 1 << lgK);
            u.update(sk);
            byte[] bytesOut6 = u.getResult(TgtHllType.HLL_8).toUpdatableByteArray();
            String comb = "LgK: " + lgK + ", SkType: HLL_6, Compared with SkType HLL_8";
            IsomorphicTest.checkArrays(bytesOut8, bytesOut6, comb, false);
            u = IsomorphicTest.buildHeapUnionHllMode(lgK, 0);
            sk = IsomorphicTest.buildHeapSketchHllMode(lgK, TgtHllType.HLL_4, 1 << lgK);
            u.update(sk);
            byte[] bytesOut4 = u.getResult(TgtHllType.HLL_8).toUpdatableByteArray();
            comb = "LgK: " + lgK + ", SkType: HLL_4, Compared with SkType HLL_8";
            IsomorphicTest.checkArrays(bytesOut8, bytesOut4, comb, false);
        }
    }

    private static void checkArrays(byte[] sk1, byte[] sk2, String comb, boolean omitHipAccum) {
        int len = sk1.length;
        if (len != sk2.length) {
            IsomorphicTest.println("Sketch images not the same length: " + comb);
            return;
        }
        IsomorphicTest.print(comb + ": ");
        for (int i = 0; i < len; ++i) {
            if (omitHipAccum && i >= 8 && i <= 15 || sk1[i] == sk2[i]) continue;
            IsomorphicTest.print(i + " ");
            Assert.fail();
        }
        IsomorphicTest.println("");
    }

    private Union buildHeapUnion(int lgMaxK, CurMode curMode) {
        Union u = new Union(lgMaxK);
        int n = curMode == null ? 0 : IsomorphicTest.getN(lgMaxK, curMode);
        for (int i = 0; i < n; ++i) {
            u.update((long)i + this.v);
        }
        this.v += (long)n;
        return u;
    }

    private Union buildMemoryUnion(int lgMaxK, CurMode curMode) {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgMaxK, (TgtHllType)TgtHllType.HLL_8);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        Union u = new Union(lgMaxK, wmem);
        int n = curMode == null ? 0 : IsomorphicTest.getN(lgMaxK, curMode);
        for (int i = 0; i < n; ++i) {
            u.update((long)i + this.v);
        }
        this.v += (long)n;
        return u;
    }

    private HllSketch buildHeapSketch(int lgK, TgtHllType tgtHllType, CurMode curMode) {
        HllSketch sk = new HllSketch(lgK, tgtHllType);
        int n = curMode == null ? 0 : IsomorphicTest.getN(lgK, curMode);
        for (int i = 0; i < n; ++i) {
            sk.update((long)i + this.v);
        }
        this.v += (long)n;
        return sk;
    }

    private HllSketch buildMemorySketch(int lgK, TgtHllType tgtHllType, CurMode curMode) {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)tgtHllType);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(lgK, tgtHllType, wmem);
        int n = curMode == null ? 0 : IsomorphicTest.getN(lgK, curMode);
        for (int i = 0; i < n; ++i) {
            sk.update((long)i + this.v);
        }
        this.v += (long)n;
        return sk;
    }

    private static Union buildHeapUnionHllMode(int lgMaxK, int startN) {
        Union u = new Union(lgMaxK);
        int n = IsomorphicTest.getN(lgMaxK, CurMode.HLL);
        for (int i = 0; i < n; ++i) {
            u.update((long)(i + startN));
        }
        return u;
    }

    private static Union buildMemoryUnionHllMode(int lgMaxK, int startN) {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgMaxK, (TgtHllType)TgtHllType.HLL_8);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        Union u = new Union(lgMaxK, wmem);
        int n = IsomorphicTest.getN(lgMaxK, CurMode.HLL);
        for (int i = 0; i < n; ++i) {
            u.update((long)(i + startN));
        }
        return u;
    }

    private static HllSketch buildHeapSketchHllMode(int lgK, TgtHllType tgtHllType, int startN) {
        HllSketch sk = new HllSketch(lgK, tgtHllType);
        int n = IsomorphicTest.getN(lgK, CurMode.HLL);
        for (int i = 0; i < n; ++i) {
            sk.update((long)(i + startN));
        }
        return sk;
    }

    private static HllSketch buildMemorySketchHllMode(int lgK, TgtHllType tgtHllType, int startN) {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)tgtHllType);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(lgK, tgtHllType, wmem);
        int n = IsomorphicTest.getN(lgK, CurMode.HLL);
        for (int i = 0; i < n; ++i) {
            sk.update((long)(i + startN));
        }
        return sk;
    }

    private static int getN(int lgK, CurMode curMode) {
        if (curMode == CurMode.LIST) {
            return 4;
        }
        if (curMode == CurMode.SET) {
            return 1 << lgK - 4;
        }
        return lgK < 8 && curMode == CurMode.HLL ? 1 << lgK : 1 << lgK - 3;
    }

    @Test
    public void checkCurMinConversion() {
        TgtHllType hll8 = TgtHllType.HLL_8;
        TgtHllType hll4 = TgtHllType.HLL_4;
        for (int lgK = 4; lgK <= 21; ++lgK) {
            HllSketch sk8 = new HllSketch(lgK, hll8);
            int n = (1 << lgK) * lgK;
            for (int i = 0; i < n; ++i) {
                sk8.update((long)i);
            }
            double est8 = sk8.getEstimate();
            AbstractHllArray aharr8 = (AbstractHllArray)sk8.hllSketchImpl;
            int curMin8 = aharr8.getCurMin();
            int numAtCurMin8 = aharr8.getNumAtCurMin();
            HllSketch sk4 = sk8.copyAs(hll4);
            AbstractHllArray aharr4 = (AbstractHllArray)sk4.hllSketchImpl;
            int curMin4 = ((AbstractHllArray)sk4.hllSketchImpl).getCurMin();
            int numAtCurMin4 = aharr4.getNumAtCurMin();
            double est4 = sk4.getEstimate();
            Assert.assertEquals((double)est4, (double)est8, (double)0.0);
            Assert.assertEquals((int)curMin4, (int)1);
        }
    }

    private static double bytesToDouble(byte[] arr, int offset) {
        long v = 0L;
        for (int i = offset; i < offset + 8; ++i) {
            v |= ((long)arr[i] & 0xFFL) << i * 8;
        }
        return Double.longBitsToDouble(v);
    }

    @Test
    public void printlnTest() {
        IsomorphicTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        IsomorphicTest.print(o.toString() + "\n");
    }

    static void print(Object o) {
    }

    static void printf(String fmt, Object ... args) {
    }
}

