/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.ThetaAnotB;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.thetacommon.HashOperations;

final class ThetaAnotBimpl
extends ThetaAnotB {
    private final short seedHash_;
    private boolean empty_;
    private long thetaLong_;
    private long[] hashArr_ = new long[0];
    private int curCount_;

    ThetaAnotBimpl(long seed) {
        this(Util.computeSeedHash(seed));
    }

    private ThetaAnotBimpl(short seedHash) {
        this.seedHash_ = seedHash;
        this.reset();
    }

    @Override
    public void setA(ThetaSketch skA) {
        if (skA == null) {
            this.reset();
            throw new SketchesArgumentException("The input argument <i>A</i> must not be null");
        }
        if (skA.isEmpty()) {
            this.reset();
            return;
        }
        Util.checkSeedHashes(this.seedHash_, skA.getSeedHash());
        this.hashArr_ = ThetaAnotBimpl.getHashArrA(skA);
        this.empty_ = false;
        this.thetaLong_ = skA.getThetaLong();
        this.curCount_ = this.hashArr_.length;
    }

    @Override
    public void notB(ThetaSketch skB) {
        if (this.empty_ || skB == null || skB.isEmpty()) {
            return;
        }
        Util.checkSeedHashes(this.seedHash_, skB.getSeedHash());
        this.thetaLong_ = Math.min(this.thetaLong_, skB.getThetaLong());
        this.hashArr_ = ThetaAnotBimpl.getResultHashArr(this.thetaLong_, this.curCount_, this.hashArr_, skB);
        this.curCount_ = this.hashArr_.length;
        this.empty_ = this.curCount_ == 0 && this.thetaLong_ == Long.MAX_VALUE;
    }

    @Override
    public CompactThetaSketch getResult(boolean reset) {
        return this.getResult(true, null, reset);
    }

    @Override
    public CompactThetaSketch getResult(boolean dstOrdered, MemorySegment dstSeg, boolean reset) {
        CompactThetaSketch result = CompactOperations.componentsToCompact(this.thetaLong_, this.curCount_, this.seedHash_, this.empty_, true, false, dstOrdered, dstSeg, (long[])this.hashArr_.clone());
        if (reset) {
            this.reset();
        }
        return result;
    }

    @Override
    public CompactThetaSketch aNotB(ThetaSketch skA, ThetaSketch skB, boolean dstOrdered, MemorySegment dstSeg) {
        if (skA == null || skB == null) {
            throw new SketchesArgumentException("Neither argument may be null");
        }
        long minThetaLong = Math.min(skA.getThetaLong(), skB.getThetaLong());
        if (skA.isEmpty()) {
            return skA.compact(dstOrdered, dstSeg);
        }
        Util.checkSeedHashes(skA.getSeedHash(), this.seedHash_);
        if (skB.isEmpty()) {
            return skA.compact(dstOrdered, dstSeg);
        }
        Util.checkSeedHashes(skB.getSeedHash(), this.seedHash_);
        long[] hashArrA = ThetaAnotBimpl.getHashArrA(skA);
        int countA = hashArrA.length;
        long[] hashArrOut = ThetaAnotBimpl.getResultHashArr(minThetaLong, countA, hashArrA, skB);
        int countOut = hashArrOut.length;
        boolean empty = countOut == 0 && minThetaLong == Long.MAX_VALUE;
        return CompactOperations.componentsToCompact(minThetaLong, countOut, this.seedHash_, empty, true, false, dstOrdered, dstSeg, hashArrOut);
    }

    @Override
    int getRetainedEntries() {
        return this.curCount_;
    }

    private static long[] getHashArrA(ThetaSketch skA) {
        CompactThetaSketch cskA = skA.compact(false, null);
        return (long[])cskA.getCache().clone();
    }

    private static long[] getResultHashArr(long minThetaLong, int countA, long[] hashArrA, ThetaSketch skB) {
        long[] hashTableB = skB instanceof CompactThetaSketch ? ThetaAnotBimpl.convertToHashTable(skB, minThetaLong, 0.9375) : skB.getCache();
        long[] tmpHashArrA = new long[countA];
        int lgHTBLen = Util.exactLog2OfLong(hashTableB.length);
        int nonMatches = 0;
        for (int i = 0; i < countA; ++i) {
            int index;
            long hash = hashArrA[i];
            if (hash == 0L || hash >= minThetaLong || (index = HashOperations.hashSearch(hashTableB, lgHTBLen, hash)) != -1) continue;
            tmpHashArrA[nonMatches] = hash;
            ++nonMatches;
        }
        return Arrays.copyOfRange(tmpHashArrA, 0, nonMatches);
    }

    private static long[] convertToHashTable(ThetaSketch sketch, long thetaLong, double rebuildThreshold) {
        int lgArrLongs = HashOperations.minLgHashTableSize(sketch.getRetainedEntries(true), rebuildThreshold);
        int arrLongs = 1 << lgArrLongs;
        long[] hashTable = new long[arrLongs];
        HashOperations.checkThetaCorruption(thetaLong);
        HashIterator it = sketch.iterator();
        while (it.next()) {
            long hash = it.get();
            if (HashOperations.continueCondition(thetaLong, hash)) continue;
            HashOperations.hashSearchOrInsert(hashTable, lgArrLongs, hash);
        }
        return hashTable;
    }

    private void reset() {
        this.thetaLong_ = Long.MAX_VALUE;
        this.empty_ = true;
        this.hashArr_ = new long[0];
        this.curCount_ = 0;
    }

    @Override
    long[] getCache() {
        return (long[])this.hashArr_.clone();
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    public boolean hasMemorySegment() {
        return false;
    }

    @Override
    public boolean isOffHeap() {
        return false;
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return false;
    }

    @Override
    boolean isEmpty() {
        return this.empty_;
    }
}

