/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputAttachedObjectsHandler {
    private static final Logger log = LoggerFactory.getLogger(InputAttachedObjectsHandler.class);

    public void addAttachedObjects(UIComponent parent, FacesContext context, Column column, UIComponentBase inputComponent) {
        List result = (List)parent.getAttributes().get("javax.faces.RetargetableHandlers");
        if (result == null) {
            return;
        }
        for (AttachedObjectHandler aoh : result) {
            log.info("applying RetargetableHandlers to component {}", (Object)inputComponent.getId());
            aoh.applyAttachedObject(context, (UIComponent)inputComponent);
        }
        result.clear();
        parent.getAttributes().remove("javax.faces.RetargetableHandlers");
    }

    public void updateAttachedObjects(UIComponent parent, FacesContext context, Column column, UIComponentBase inputComponent) {
    }

    protected Object getTagAttributeValue(UIComponent component, String name) {
        ValueExpression ve;
        Object value = component.getAttributes().get(name);
        if (value == null && (ve = component.getValueExpression(name)) != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            value = ve.getValue(ctx.getELContext());
        }
        return value;
    }

    protected final String getTagAttributeValueString(UIComponent component, String name) {
        return StringUtils.toString((Object)this.getTagAttributeValue(component, name));
    }
}

