/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.bnd;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.service.reporter.Reporter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.felix.ipojo.bnd.ByteArrayResource;
import org.apache.felix.ipojo.bnd.Manifests;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.ResourceVisitor;
import org.apache.felix.ipojo.manipulator.render.MetadataRenderer;
import org.apache.felix.ipojo.manipulator.util.Constants;
import org.apache.felix.ipojo.manipulator.util.Metadatas;
import org.apache.felix.ipojo.manipulator.util.Streams;
import org.apache.felix.ipojo.metadata.Element;

public class BndJarResourceStore
implements ResourceStore {
    private Analyzer m_analyzer;
    private Reporter m_reporter;
    private MetadataRenderer m_renderer = new MetadataRenderer();
    private List<Element> m_metadata = new ArrayList<Element>();
    private boolean m_includeEmbedComponents;

    public BndJarResourceStore(Analyzer analyzer, Reporter reporter) {
        this.m_analyzer = analyzer;
        this.m_reporter = reporter;
    }

    public byte[] read(String path) throws IOException {
        Resource resource = this.m_analyzer.getJar().getResource(path);
        if (resource == null) {
            Jar embed = this.findJar(path);
            if (embed == null) {
                throw new IOException(String.format("Cannot find resource %s in jar and classpath", path));
            }
            resource = embed.getResource(path);
        }
        InputStream is = null;
        try {
            is = resource.openInputStream();
        }
        catch (Exception e) {
            throw new IOException("Cannot read " + path);
        }
        return Streams.readBytes((InputStream)is);
    }

    public void accept(ResourceVisitor visitor) {
        try {
            Collection<Clazz> classes = this.m_analyzer.getClasses(new String[]{"", Clazz.QUERY.CLASSANNOTATIONS.name()});
            classes = this.filter(classes);
            for (Clazz clazz : classes) {
                visitor.visit(clazz.getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.m_reporter.error("Cannot find iPOJO annotated types: " + e.getMessage(), new Object[0]);
        }
    }

    private Collection<Clazz> filter(Collection<Clazz> classes) throws Exception {
        HashSet<Clazz> manipulable = new HashSet<Clazz>();
        for (Clazz clazz : classes) {
            if (this.m_analyzer.getJar().getResource(clazz.getAbsolutePath()) != null) {
                manipulable.add(clazz);
                continue;
            }
            if (this.m_includeEmbedComponents) {
                Jar jar = this.findJar(clazz.getAbsolutePath());
                if (jar == null) {
                    this.m_reporter.error("Resource for class %s not found in classpath", new Object[]{clazz.getFQN()});
                    continue;
                }
                if (jar.getBsn() != null) {
                    Attributes attr = jar.getManifest().getMainAttributes();
                    if (Manifests.getComponents(attr) != null) continue;
                    manipulable.add(clazz);
                    continue;
                }
                this.m_reporter.warning("Class %s found in a non-Bundle archive %s", new Object[]{clazz.getFQN(), jar.getName()});
                continue;
            }
            this.m_reporter.warning("Embed components are excluded, Component %s will not be manipulated", new Object[]{clazz.getFQN()});
        }
        return manipulable;
    }

    private Jar findJar(String path) {
        for (Jar jar : this.m_analyzer.getClasspath()) {
            if (jar.getResource(path) == null) continue;
            return jar;
        }
        return null;
    }

    public void open() throws IOException {
    }

    public void writeMetadata(Element metadata) {
        this.m_metadata.add(metadata);
        for (String referred : Metadatas.findReferredPackages((Element)metadata)) {
            if (this.m_analyzer.getReferred().containsFQN(referred)) continue;
            this.m_analyzer.getReferred().put(this.m_analyzer.getPackageRef(referred), new Attrs(new Attrs[0]));
        }
    }

    public void write(String resourcePath, byte[] resource) throws IOException {
        Jar jar = this.m_analyzer.getJar();
        jar.putResource(resourcePath, (Resource)new ByteArrayResource(resource));
    }

    public void close() throws IOException {
        StringBuilder builder = new StringBuilder();
        if (this.m_includeEmbedComponents) {
            for (Jar jar : this.m_analyzer.getClasspath()) {
                try {
                    Manifest manifest = jar.getManifest();
                    Attributes main = manifest.getMainAttributes();
                    String components = Manifests.getComponents(main);
                    if (components == null) continue;
                    this.m_reporter.trace("Merging components from %s", new Object[]{jar.getName()});
                    builder.append(components);
                }
                catch (Exception e) {
                    this.m_reporter.warning("Cannot open MANIFEST of %s", new Object[]{jar.getName()});
                }
            }
        }
        for (Element metadata : this.m_metadata) {
            builder.append(this.m_renderer.render(metadata));
        }
        if (builder.length() != 0) {
            this.m_analyzer.setProperty("IPOJO-Components", builder.toString());
        }
        Attrs version = new Attrs(new Attrs[0]);
        version.put("version:Version", Constants.getPackageImportClause());
        if (!this.m_analyzer.getReferred().containsFQN("org.apache.felix.ipojo")) {
            this.m_analyzer.getReferred().put(this.m_analyzer.getPackageRef("org.apache.felix.ipojo"), version);
        }
        if (!this.m_analyzer.getReferred().containsFQN("org.apache.felix.ipojo.architecture")) {
            this.m_analyzer.getReferred().put(this.m_analyzer.getPackageRef("org.apache.felix.ipojo.architecture"), version);
        }
        if (!this.m_analyzer.getReferred().containsFQN("org.osgi.service.cm")) {
            Attrs cm = new Attrs(new Attrs[0]);
            cm.put("version:Version", "1.2");
            this.m_analyzer.getReferred().put(this.m_analyzer.getPackageRef("org.osgi.service.cm"), cm);
        }
        if (!this.m_analyzer.getReferred().containsFQN("org.osgi.service.log")) {
            Attrs log = new Attrs(new Attrs[0]);
            log.put("version:Version", "1.3");
            this.m_analyzer.getReferred().put(this.m_analyzer.getPackageRef("org.osgi.service.log"), log);
        }
    }

    public void setIncludeEmbedComponents(boolean excludeEmbedComponents) {
        this.m_includeEmbedComponents = excludeEmbedComponents;
    }
}

