/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core.plugins;

import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.felix.atomos.utils.api.Config;
import org.apache.felix.atomos.utils.api.Context;
import org.apache.felix.atomos.utils.api.plugin.JarPlugin;
import org.apache.felix.atomos.utils.substrate.api.resource.ResourceConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultResourceConfiguration;

public class ResourcePlugin
implements JarPlugin<Config> {
    private static String CLASS_SUFFIX = ".class";
    private static Collection<String> EXCLUDE_DIRS = Collections.unmodifiableList(Arrays.asList("META-INF/", "OSGI-INF/", "OSGI-OPT/"));
    private static Collection<String> EXCLUDE_NAMES = Collections.unmodifiableList(Arrays.asList("/packageinfo"));
    private static String FRENCH_BUNDLE_CLASS = "_fr.class";
    private static String FRENCH_BUNDLE_PROPS = "_fr.properties";
    private static String SERVICES = "META-INF/services/";

    public void doJar(JarFile jar, Context context, URLClassLoader classLoader) {
        DefaultResourceConfiguration resourceConfig = new DefaultResourceConfiguration();
        block0: for (JarEntry entry : jar.stream().collect(Collectors.toList())) {
            String entryName = entry.getName();
            if (entry.isDirectory() || entryName.indexOf(47) == -1) continue;
            if (entryName.startsWith(SERVICES)) {
                resourceConfig.addResourcePattern(entryName);
                continue;
            }
            for (String excluded : EXCLUDE_NAMES) {
                if (!entryName.endsWith(excluded)) continue;
                continue block0;
            }
            for (String excluded : EXCLUDE_DIRS) {
                if (!entryName.startsWith(excluded)) continue;
                continue block0;
            }
            if (entryName.endsWith(CLASS_SUFFIX)) {
                if (!entryName.endsWith(FRENCH_BUNDLE_CLASS)) continue;
                String bundleName = entryName.substring(0, entryName.length() - FRENCH_BUNDLE_CLASS.length()).replace('/', '.');
                String bundlePackage = bundleName.substring(0, bundleName.lastIndexOf(46));
                resourceConfig.addResourceBundle(bundleName);
                resourceConfig.addResourcePackage(bundlePackage);
                continue;
            }
            if (entryName.endsWith(FRENCH_BUNDLE_PROPS)) {
                resourceConfig.addResourceBundle(entryName.substring(0, entryName.length() - FRENCH_BUNDLE_PROPS.length()).replace('/', '.'));
                continue;
            }
            resourceConfig.addResourcePattern(entryName);
        }
        context.addResourceConfig((ResourceConfiguration)resourceConfig);
    }

    public void init(Config config) {
    }
}

