/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckExecutor;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.core.impl.executor.CombinedExecutionResult;
import org.apache.felix.hc.core.impl.servlet.HealthCheckExecutorServletConfiguration;
import org.apache.felix.hc.core.impl.servlet.ResultHtmlSerializer;
import org.apache.felix.hc.core.impl.servlet.ResultJsonSerializer;
import org.apache.felix.hc.core.impl.servlet.ResultTxtSerializer;
import org.apache.felix.hc.core.impl.servlet.ResultTxtVerboseSerializer;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.osgi.dto.DTO;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=HealthCheckExecutorServletConfiguration.class, factory=true)
public class HealthCheckExecutorServlet
extends HttpServlet {
    private static final long serialVersionUID = 8013511523994541848L;
    private final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String PARAM_SPLIT_REGEX = "[,;]+";
    static final Param PARAM_TAGS = new Param("tags", "Comma-separated list of health checks tags to select - can also be specified via path, e.g. /system/health/tag1,tag2.json. Exclusions can be done by prepending '-' to the tag name");
    static final Param PARAM_FORMAT = new Param("format", null);
    static final Param PARAM_HTTP_STATUS = new Param("httpStatus", "Specify HTTP result code, for example CRITICAL:503 (status 503 if result >= CRITICAL) or CRITICAL:503,HEALTH_CHECK_ERROR:500,OK:418 for more specific HTTP status");
    static final Param PARAM_COMBINE_TAGS_WITH_OR = new Param("combineTagsWithOr", "Combine tags with OR, active by default. Set to false to combine with AND");
    static final Param PARAM_FORCE_INSTANT_EXECUTION = new Param("forceInstantExecution", "If true, forces instant execution by executing async health checks directly, circumventing the cache (2sec by default) of the HealthCheckExecutor");
    static final Param PARAM_OVERRIDE_GLOBAL_TIMEOUT = new Param("timeout", "(msec) a timeout status is returned for any health check still running after this period. Overrides the default HealthCheckExecutor timeout");
    static final Param PARAM_INCLUDE_DEBUG = new Param("hcDebug", "Include the DEBUG output of the Health Checks");
    static final Param PARAM_NAMES = new Param("names", "Comma-separated list of health check names to select. Exclusions can be done by prepending '-' to the health check name");
    static final String JSONP_CALLBACK_DEFAULT = "processHealthCheckResults";
    static final Param PARAM_JSONP_CALLBACK = new Param("callback", "name of the JSONP callback function to use, defaults to processHealthCheckResults");
    static final Param[] PARAM_LIST = new Param[]{PARAM_TAGS, PARAM_NAMES, PARAM_FORMAT, PARAM_HTTP_STATUS, PARAM_COMBINE_TAGS_WITH_OR, PARAM_FORCE_INSTANT_EXECUTION, PARAM_OVERRIDE_GLOBAL_TIMEOUT, PARAM_INCLUDE_DEBUG, PARAM_JSONP_CALLBACK};
    static final String FORMAT_HTML = "html";
    static final String FORMAT_JSON = "json";
    static final String FORMAT_JSONP = "jsonp";
    static final String FORMAT_TXT = "txt";
    static final String FORMAT_VERBOSE_TXT = "verbose.txt";
    private static final String CONTENT_TYPE_HTML = "text/html";
    private static final String CONTENT_TYPE_TXT = "text/plain";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_JSONP = "application/javascript";
    private static final String STATUS_HEADER_NAME = "X-Health";
    private static final String CACHE_CONTROL_KEY = "Cache-control";
    private static final String CACHE_CONTROL_VALUE = "no-cache";
    private static final String CORS_ORIGIN_HEADER_NAME = "Access-Control-Allow-Origin";
    private String servletPath;
    private String corsAccessControlAllowOrigin;
    private Map<Result.Status, Integer> defaultStatusMapping;
    private Map<String, ServiceRegistration<Servlet>> servletRegistrations;
    private BundleContext bundleContext;
    private long servletDefaultTimeout;
    private String[] servletDefaultTags;
    private String defaultFormat;
    private String[] allowedFormats;
    private boolean defaultCombineTagsWithOr;
    private boolean disableRequestConfiguration;
    @Reference
    HealthCheckExecutor healthCheckExecutor;
    @Reference
    ResultHtmlSerializer htmlSerializer;
    @Reference
    ResultJsonSerializer jsonSerializer;
    @Reference
    ResultTxtSerializer txtSerializer;
    @Reference
    ResultTxtVerboseSerializer verboseTxtSerializer;

    @Activate
    protected final void activate(HealthCheckExecutorServletConfiguration configuration, BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.servletRegistrations = new HashMap<String, ServiceRegistration<Servlet>>();
        this.servletPath = configuration.servletPath();
        this.defaultStatusMapping = this.getStatusMapping(configuration.httpStatusMapping());
        this.servletDefaultTimeout = configuration.timeout();
        this.servletDefaultTags = configuration.tags();
        this.defaultCombineTagsWithOr = configuration.combineTagsWithOr();
        this.defaultFormat = configuration.format();
        this.allowedFormats = configuration.allowed_formats();
        if (!this.isFormatAllowed(this.defaultFormat)) {
            String[] allFormats = new String[this.allowedFormats.length + 1];
            System.arraycopy(this.allowedFormats, 0, allFormats, 0, this.allowedFormats.length);
            allFormats[this.allowedFormats.length] = this.defaultFormat;
            this.allowedFormats = allFormats;
        }
        PARAM_FORMAT.setDescription("Output format, " + String.join((CharSequence)"|", this.allowedFormats) + " - an extension in the URL overrides this");
        this.corsAccessControlAllowOrigin = configuration.cors_accessControlAllowOrigin();
        this.disableRequestConfiguration = configuration.disable_request_configuration();
        if (configuration.disabled()) {
            this.LOG.info("Health Check Servlet is disabled by configuration");
            return;
        }
        this.LOG.info("Health Check Servlet Configuration: servletPath={}, defaultStatusMapping={}, servletDefaultTimeout={}, servletDefaultTags={}, defaultCombineTagsWithOr={}, defaultFormat={}, allowedFormats={}, corsAccessControlAllowOrigin={}", new Object[]{this.servletPath, this.defaultStatusMapping, this.servletDefaultTimeout, this.servletDefaultTags != null ? Arrays.asList(this.servletDefaultTags) : "<none>", this.defaultCombineTagsWithOr, this.defaultFormat, Arrays.toString(this.allowedFormats), this.corsAccessControlAllowOrigin});
        LinkedHashMap<String, HttpServlet> servletsToRegister = new LinkedHashMap<String, HttpServlet>();
        servletsToRegister.put(this.servletPath, this);
        if (this.isFormatAllowed(FORMAT_HTML)) {
            servletsToRegister.put(this.servletPath.concat(".").concat(FORMAT_HTML), new ProxyServlet(FORMAT_HTML));
        }
        if (this.isFormatAllowed(FORMAT_JSON)) {
            servletsToRegister.put(this.servletPath.concat(".").concat(FORMAT_JSON), new ProxyServlet(FORMAT_JSON));
        }
        if (this.isFormatAllowed(FORMAT_JSONP)) {
            servletsToRegister.put(this.servletPath.concat(".").concat(FORMAT_JSONP), new ProxyServlet(FORMAT_JSONP));
        }
        if (this.isFormatAllowed(FORMAT_TXT)) {
            servletsToRegister.put(this.servletPath.concat(".").concat(FORMAT_TXT), new ProxyServlet(FORMAT_TXT));
        }
        if (this.isFormatAllowed(FORMAT_VERBOSE_TXT)) {
            servletsToRegister.put(this.servletPath.concat(".").concat(FORMAT_VERBOSE_TXT), new ProxyServlet(FORMAT_VERBOSE_TXT));
        }
        for (Map.Entry servlet : servletsToRegister.entrySet()) {
            try {
                this.LOG.info("Registering HC Servlet > Name: '{}', Path: '{}'", (Object)((Object)((Object)this)).getClass().getSimpleName(), servlet.getKey());
                ServletInfoDTO servletInfo = new ServletInfoDTO(configuration.servletContextName(), (String)servlet.getKey(), (Servlet)servlet.getValue());
                this.registerServlet(servletInfo);
            }
            catch (Exception e) {
                this.LOG.error("Could not register health check servlet: " + e, (Throwable)e);
            }
        }
    }

    @Deactivate
    public void deactivate() {
        for (Map.Entry<String, ServiceRegistration<Servlet>> entry : this.servletRegistrations.entrySet()) {
            try {
                this.LOG.info("Unregistering HC Servlet {} from path {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)entry.getKey());
                entry.getValue().unregister();
            }
            catch (Exception exception) {}
        }
        this.servletRegistrations.clear();
    }

    private void registerServlet(ServletInfoDTO servletInfo) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (servletInfo.contextName != null && !servletInfo.contextName.isEmpty()) {
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "(".concat("osgi.http.whiteboard.context.name").concat("=").concat(servletInfo.contextName).concat(")"));
        }
        ((Dictionary)properties).put("osgi.http.whiteboard.servlet.pattern", servletInfo.servletPath);
        ServiceRegistration registration = this.bundleContext.registerService(Servlet.class, (Object)servletInfo.servlet, properties);
        this.servletRegistrations.put(this.servletPath, (ServiceRegistration<Servlet>)registration);
    }

    private boolean isFormatAllowed(String format) {
        for (String f : this.allowedFormats) {
            if (!f.equals(format)) continue;
            return true;
        }
        return false;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response, String pathTokensStr, String format) throws ServletException, IOException {
        String overrideGlobalTimeoutVal;
        HealthCheckSelector selector = HealthCheckSelector.empty();
        List<Object> tags = new ArrayList();
        List<String> names = new ArrayList<String>();
        if (!this.disableRequestConfiguration && StringUtils.isNotBlank(pathTokensStr)) {
            String[] pathTokens;
            for (String pathToken : pathTokens = pathTokensStr.split(PARAM_SPLIT_REGEX)) {
                if (pathToken.indexOf(32) >= 0) {
                    names.add(pathToken);
                    continue;
                }
                tags.add(pathToken);
            }
        }
        if (tags.size() == 0) {
            String tagsParameter = this.disableRequestConfiguration ? null : request.getParameter(HealthCheckExecutorServlet.PARAM_TAGS.name);
            tags = Arrays.asList(StringUtils.isNotBlank(tagsParameter) ? tagsParameter.split(PARAM_SPLIT_REGEX) : this.servletDefaultTags);
        }
        selector.withTags(tags.toArray(new String[0]));
        if (names.size() == 0 && !this.disableRequestConfiguration) {
            names = Arrays.asList(StringUtils.defaultIfBlank(request.getParameter(HealthCheckExecutorServlet.PARAM_NAMES.name), "").split(PARAM_SPLIT_REGEX));
        }
        selector.withNames(names.toArray(new String[0]));
        boolean includeDebug = this.disableRequestConfiguration ? false : Boolean.valueOf(request.getParameter(HealthCheckExecutorServlet.PARAM_INCLUDE_DEBUG.name));
        String httpStatusMappingParameterVal = this.disableRequestConfiguration ? null : request.getParameter(HealthCheckExecutorServlet.PARAM_HTTP_STATUS.name);
        Map<Result.Status, Integer> statusMapping = httpStatusMappingParameterVal != null ? this.getStatusMapping(httpStatusMappingParameterVal) : this.defaultStatusMapping;
        HealthCheckExecutionOptions executionOptions = new HealthCheckExecutionOptions();
        String paramCombineTagsWithOr = this.disableRequestConfiguration ? null : request.getParameter(HealthCheckExecutorServlet.PARAM_COMBINE_TAGS_WITH_OR.name);
        executionOptions.setCombineTagsWithOr(paramCombineTagsWithOr != null ? Boolean.valueOf(paramCombineTagsWithOr) : this.defaultCombineTagsWithOr);
        if (!this.disableRequestConfiguration) {
            executionOptions.setForceInstantExecution(Boolean.valueOf(request.getParameter(HealthCheckExecutorServlet.PARAM_FORCE_INSTANT_EXECUTION.name)).booleanValue());
        }
        String string = overrideGlobalTimeoutVal = this.disableRequestConfiguration ? null : request.getParameter(HealthCheckExecutorServlet.PARAM_OVERRIDE_GLOBAL_TIMEOUT.name);
        if (StringUtils.isNotBlank(overrideGlobalTimeoutVal)) {
            executionOptions.setOverrideGlobalTimeout(Integer.valueOf(overrideGlobalTimeoutVal).intValue());
        } else if (this.servletDefaultTimeout > -1L) {
            executionOptions.setOverrideGlobalTimeout((int)this.servletDefaultTimeout);
        }
        List executionResults = this.healthCheckExecutor.execute(selector, executionOptions);
        CombinedExecutionResult combinedExecutionResult = new CombinedExecutionResult(executionResults);
        Result overallResult = combinedExecutionResult.getHealthCheckResult();
        this.sendNoCacheHeaders(response);
        this.sendCorsHeaders(response);
        Integer httpStatus = statusMapping.get(overallResult.getStatus());
        response.setStatus(httpStatus.intValue());
        response.setHeader(STATUS_HEADER_NAME, overallResult.getStatus().toString());
        boolean formatAllowed = this.isFormatAllowed(format);
        if (formatAllowed && FORMAT_HTML.equals(format)) {
            this.sendHtmlResponse(overallResult, executionResults, request, response, includeDebug);
        } else if (formatAllowed && FORMAT_JSON.equals(format)) {
            this.sendJsonResponse(overallResult, executionResults, null, response, includeDebug);
        } else if (formatAllowed && FORMAT_JSONP.equals(format)) {
            String jsonpCallback = StringUtils.defaultIfBlank(request.getParameter(HealthCheckExecutorServlet.PARAM_JSONP_CALLBACK.name), JSONP_CALLBACK_DEFAULT);
            this.sendJsonResponse(overallResult, executionResults, jsonpCallback, response, includeDebug);
        } else if (formatAllowed && format != null && format.endsWith(FORMAT_TXT)) {
            this.sendTxtResponse(overallResult, response, FORMAT_VERBOSE_TXT.equals(format), executionResults, includeDebug);
        } else {
            response.setContentType(CONTENT_TYPE_TXT);
            response.getWriter().println("Invalid format " + format + " - supported formats: " + Arrays.toString(this.allowedFormats));
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathTokensStr;
        String[] splitPathInfo = this.splitFormat(request.getPathInfo());
        String format = splitPathInfo[1];
        if (format == null) {
            format = StringUtils.defaultIfBlank(request.getParameter(HealthCheckExecutorServlet.PARAM_FORMAT.name), this.defaultFormat);
        }
        if ((pathTokensStr = splitPathInfo[0]) != null && pathTokensStr.startsWith("/")) {
            pathTokensStr = pathTokensStr.substring(1, pathTokensStr.length());
        }
        this.doGet(request, response, pathTokensStr, format);
    }

    String[] splitFormat(String pathInfo) {
        if (pathInfo != null) {
            for (String format : new String[]{FORMAT_HTML, FORMAT_JSON, FORMAT_JSONP, FORMAT_VERBOSE_TXT, FORMAT_TXT}) {
                String formatWithDot = ".".concat(format);
                if (!pathInfo.endsWith(formatWithDot)) continue;
                return new String[]{pathInfo.substring(0, pathInfo.length() - formatWithDot.length()), format};
            }
        }
        return new String[]{pathInfo, null};
    }

    private void sendTxtResponse(Result overallResult, HttpServletResponse response, boolean verbose, List<HealthCheckExecutionResult> executionResults, boolean includeDebug) throws IOException {
        response.setContentType(CONTENT_TYPE_TXT);
        response.setCharacterEncoding("UTF-8");
        if (verbose) {
            response.getWriter().write(this.verboseTxtSerializer.serialize(overallResult, executionResults, includeDebug));
        } else {
            response.getWriter().write(this.txtSerializer.serialize(overallResult));
        }
    }

    private void sendJsonResponse(Result overallResult, List<HealthCheckExecutionResult> executionResults, String jsonpCallback, HttpServletResponse response, boolean includeDebug) throws IOException {
        if (StringUtils.isNotBlank(jsonpCallback)) {
            response.setContentType(CONTENT_TYPE_JSONP);
        } else {
            response.setContentType(CONTENT_TYPE_JSON);
        }
        response.setCharacterEncoding("UTF-8");
        String resultJson = this.jsonSerializer.serialize(overallResult, executionResults, jsonpCallback, includeDebug);
        PrintWriter writer = response.getWriter();
        writer.append(resultJson);
    }

    private void sendHtmlResponse(Result overallResult, List<HealthCheckExecutionResult> executionResults, HttpServletRequest request, HttpServletResponse response, boolean includeDebug) throws IOException {
        response.setContentType(CONTENT_TYPE_HTML);
        response.setCharacterEncoding("UTF-8");
        List<Param> allowedParameters = this.disableRequestConfiguration ? Arrays.asList(PARAM_FORMAT) : Arrays.asList(PARAM_LIST);
        response.getWriter().append(this.htmlSerializer.serialize(overallResult, executionResults, allowedParameters, includeDebug));
    }

    private void sendNoCacheHeaders(HttpServletResponse response) {
        response.setHeader(CACHE_CONTROL_KEY, CACHE_CONTROL_VALUE);
    }

    private void sendCorsHeaders(HttpServletResponse response) {
        if (StringUtils.isNotBlank(this.corsAccessControlAllowOrigin)) {
            response.setHeader(CORS_ORIGIN_HEADER_NAME, this.corsAccessControlAllowOrigin);
        }
    }

    Map<Result.Status, Integer> getStatusMapping(String mappingStr) {
        TreeMap<Result.Status, Integer> statusMapping = new TreeMap<Result.Status, Integer>();
        try {
            String[] bits;
            for (String bit : bits = mappingStr.split("[,]")) {
                String[] tuple = bit.split("[:]");
                statusMapping.put(Result.Status.valueOf((String)tuple[0]), Integer.parseInt(tuple[1]));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid parameter httpStatus=" + mappingStr + " " + e, e);
        }
        if (!statusMapping.containsKey(Result.Status.OK)) {
            statusMapping.put(Result.Status.OK, 200);
        }
        if (!statusMapping.containsKey(Result.Status.WARN)) {
            statusMapping.put(Result.Status.WARN, (Integer)statusMapping.get(Result.Status.OK));
        }
        if (!statusMapping.containsKey(Result.Status.TEMPORARILY_UNAVAILABLE)) {
            statusMapping.put(Result.Status.TEMPORARILY_UNAVAILABLE, 503);
        }
        if (!statusMapping.containsKey(Result.Status.CRITICAL)) {
            statusMapping.put(Result.Status.CRITICAL, 503);
        }
        if (!statusMapping.containsKey(Result.Status.HEALTH_CHECK_ERROR)) {
            statusMapping.put(Result.Status.HEALTH_CHECK_ERROR, 500);
        }
        return statusMapping;
    }

    private static class ServletInfoDTO
    extends DTO {
        String contextName;
        String servletPath;
        Servlet servlet;

        public ServletInfoDTO(String contextName, String servletPath, Servlet servlet) {
            this.contextName = contextName;
            this.servletPath = servletPath;
            this.servlet = servlet;
        }
    }

    private class ProxyServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private final String format;

        private ProxyServlet(String format) {
            this.format = format;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            HealthCheckExecutorServlet.this.doGet(req, resp, null, this.format);
        }
    }

    static class Param {
        final String name;
        String description;

        Param(String n, String d) {
            this.name = n;
            this.description = d;
        }

        void setDescription(String d) {
            this.description = d;
        }
    }
}

