/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api;

import org.apache.felix.ipojo.api.HandlerConfiguration;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class TemporalDependency
implements HandlerConfiguration {
    public static final String NULLABLE = "nullable";
    public static final String EMPTY = "empty";
    public static final String NULL = "null";
    private String m_specification;
    private String m_filter;
    private String m_field;
    private String m_onTimeout;
    private String m_timeout;
    private boolean m_proxy = false;

    public Element getElement() {
        this.ensureValidity();
        Element dep = new Element("requires", "org.apache.felix.ipojo.handler.temporal");
        if (this.m_specification != null) {
            dep.addAttribute(new Attribute("specification", this.m_specification));
        }
        if (this.m_filter != null) {
            dep.addAttribute(new Attribute("filter", this.m_filter));
        }
        if (this.m_field != null) {
            dep.addAttribute(new Attribute("field", this.m_field));
        }
        if (this.m_onTimeout != null) {
            dep.addAttribute(new Attribute("omTimeout", this.m_onTimeout));
        }
        if (this.m_timeout != null) {
            dep.addAttribute(new Attribute("timeout", this.m_timeout));
        }
        if (this.m_proxy) {
            dep.addAttribute(new Attribute("proxy", "true"));
        }
        return dep;
    }

    public TemporalDependency setSpecification(String spec) {
        this.m_specification = spec;
        return this;
    }

    public TemporalDependency setFilter(String filter) {
        this.m_filter = filter;
        return this;
    }

    public TemporalDependency setField(String field) {
        this.m_field = field;
        return this;
    }

    public TemporalDependency setProxy(boolean proxy) {
        this.m_proxy = proxy;
        return this;
    }

    public TemporalDependency setTimeout(String time) {
        this.m_timeout = time;
        return this;
    }

    public TemporalDependency setTimeout(long time) {
        this.m_timeout = new Long(time).toString();
        return this;
    }

    public TemporalDependency setOnTimeoutPolicy(String tip) {
        this.m_onTimeout = tip;
        return this;
    }

    private void ensureValidity() {
        if (this.m_field == null) {
            throw new IllegalStateException("A temporal dependency must have a field");
        }
    }
}

