/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.endpoints;

import flex.management.BaseControl;
import flex.management.runtime.messaging.MessageBrokerControl;
import flex.management.runtime.messaging.endpoints.EndpointControlMBean;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.endpoints.Endpoint;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class EndpointControl
extends BaseControl
implements EndpointControlMBean {
    protected Endpoint endpoint;
    private AtomicInteger serviceMessageCount = new AtomicInteger(0);
    private Date lastServiceMessageTimestamp;
    private long serviceMessageStart;
    private AtomicLong bytesDeserialized = new AtomicLong(0L);
    private AtomicLong bytesSerialized = new AtomicLong(0L);

    public EndpointControl(Endpoint endpoint, BaseControl parent) {
        super(parent);
        this.endpoint = endpoint;
        this.serviceMessageStart = System.currentTimeMillis();
    }

    @Override
    protected void onRegistrationComplete() {
        String name = this.getObjectName().getCanonicalName();
        String[] generalNames = new String[]{"SecurityConstraint"};
        String[] generalPollables = new String[]{"ServiceMessageCount", "LastServiceMessageTimestamp", "ServiceMessageFrequency"};
        String[] pollableGraphByInterval = new String[]{"BytesDeserialized", "BytesSerialized"};
        this.getRegistrar().registerObjects(100, name, generalNames);
        this.getRegistrar().registerObjects(101, name, generalPollables);
        this.getRegistrar().registerObjects(new int[]{50, 101}, name, pollableGraphByInterval);
    }

    @Override
    public String getId() {
        return this.endpoint.getId();
    }

    @Override
    public Boolean isRunning() {
        return this.endpoint.isStarted();
    }

    @Override
    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Integer getServiceMessageCount() {
        return this.serviceMessageCount.get();
    }

    @Override
    public void resetServiceMessageCount() {
        this.serviceMessageStart = System.currentTimeMillis();
        this.serviceMessageCount = new AtomicInteger(0);
        this.lastServiceMessageTimestamp = null;
    }

    public void incrementServiceMessageCount() {
        this.serviceMessageCount.incrementAndGet();
        this.lastServiceMessageTimestamp = new Date();
    }

    @Override
    public Date getLastServiceMessageTimestamp() {
        return this.lastServiceMessageTimestamp;
    }

    @Override
    public Double getServiceMessageFrequency() {
        if (this.serviceMessageCount.get() > 0) {
            double runtime = this.differenceInMinutes(this.serviceMessageStart, System.currentTimeMillis());
            return new Double((double)this.serviceMessageCount.get() / runtime);
        }
        return new Double(0.0);
    }

    @Override
    public void preDeregister() throws Exception {
        MessageBrokerControl parent = (MessageBrokerControl)this.getParentControl();
        parent.removeEndpoint(this.getObjectName());
    }

    @Override
    public String getURI() {
        return this.endpoint.getUrl();
    }

    @Override
    public String getSecurityConstraint() {
        return EndpointControl.getSecurityConstraintOf(this.endpoint);
    }

    public static String getSecurityConstraintOf(Endpoint endpoint) {
        String authMethod;
        String result = "None";
        SecurityConstraint constraint = endpoint.getSecurityConstraint();
        if (constraint != null && (authMethod = constraint.getMethod()) != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(authMethod);
            List roles = constraint.getRoles();
            if (roles != null && !roles.isEmpty()) {
                buffer.append(':');
                for (int i = 0; i < roles.size(); ++i) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    buffer.append(' ');
                    buffer.append(roles.get(i));
                }
            }
            result = buffer.toString();
        }
        return result;
    }

    @Override
    public Long getBytesDeserialized() {
        return this.bytesDeserialized.get();
    }

    public void addToBytesDeserialized(int currentBytesDeserialized) {
        this.bytesDeserialized.addAndGet(currentBytesDeserialized);
    }

    @Override
    public Long getBytesSerialized() {
        return this.bytesSerialized.get();
    }

    public void addToBytesSerialized(int currentBytesSerialized) {
        this.bytesSerialized.addAndGet(currentBytesSerialized);
    }
}

