/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.DestinationControl;
import flex.messaging.Destination;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;

public abstract class ServiceAdapter
extends ManageableComponent {
    public static final String LOG_CATEGORY = "Service.General";

    public ServiceAdapter() {
        this(false);
    }

    public ServiceAdapter(boolean enableManagement) {
        super(enableManagement);
    }

    @Override
    protected void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        Destination destination = this.getDestination();
        if (!destination.isStarted()) {
            if (Log.isWarn()) {
                Log.getLogger((String)this.getLogCategory()).warn("Adapter with id '{0}' cannot be started when its Destination with id '{1}' is not started.", new Object[]{this.getId(), destination.getId()});
            }
            return;
        }
        if (this.isManaged() && destination.isManaged()) {
            this.setupAdapterControl(destination);
            DestinationControl controller = (DestinationControl)destination.getControl();
            if (this.getControl() != null) {
                controller.setAdapter(this.getControl().getObjectName());
            }
        }
        super.start();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        if (this.isManaged() && this.getDestination().isManaged()) {
            if (this.getControl() != null) {
                this.getControl().unregister();
                this.setControl(null);
            }
            this.setManaged(false);
        }
    }

    public Destination getDestination() {
        return (Destination)this.getParent();
    }

    public void setDestination(Destination destination) {
        Destination oldDestination = this.getDestination();
        this.setParent(destination);
        if (oldDestination != null) {
            oldDestination.setAdapter(null);
        }
        if (destination.getAdapter() != this) {
            destination.setAdapter(this);
        }
    }

    public abstract Object invoke(Message var1);

    public Object manage(CommandMessage commandMessage) {
        return null;
    }

    public Object getAdapterState() {
        throw new UnsupportedOperationException();
    }

    public void setAdapterState(Object adapterState) {
        throw new UnsupportedOperationException();
    }

    public boolean handlesSubscriptions() {
        return false;
    }

    @Override
    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected void setupAdapterControl(Destination destination) {
        this.setManaged(false);
    }
}

