/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.validators;

import flex.messaging.config.ConfigMap;
import flex.messaging.validators.DeserializationValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ClassDeserializationValidator
implements DeserializationValidator {
    public static final String PROPERTY_ALLOW_CLASSES = "allow-classes";
    public static final String PROPERTY_DISALLOW_CLASSES = "disallow-classes";
    public static final String PROPERTY_CLASS_ATTR = "class";
    public static final String PROPERTY_NAME_ATTR = "name";
    private static final String[] DEFAULT_ALLOW_CLASSES = new String[]{"flex.messaging.io.amf.ASObject", "flex.messaging.io.amf.SerializedObject", "flex.messaging.io.ArrayCollection", "flex.messaging.io.ArrayList", "flex.messaging.messages.AcknowledgeMessage", "flex.messaging.messages.AcknowledgeMessageExt", "flex.messaging.messages.AsyncMessage", "flex.messaging.messages.AsyncMessageExt", "flex.messaging.messages.CommandMessage", "flex.messaging.messages.CommandMessageExt", "flex.messaging.messages.ErrorMessage", "flex.messaging.messages.HTTPMessage", "flex.messaging.messages.RemotingMessage", "flex.messaging.messages.SOAPMessage", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Object", "java.lang.Short", "java.lang.String", "java.util.ArrayList", "java.util.Date", "java.util.HashMap", "org.w3c.dom.Document", "\\[B", "\\[Ljava.lang.Object;"};
    protected final Object lock = new Object();
    private Set<String> allowClasses;
    private Set<String> disallowClasses;
    private Map<String, Pattern> allowClassPatterns;
    private Map<String, Pattern> disallowClassPatterns;

    public ClassDeserializationValidator() {
        for (String defaultAllowClassPattern : DEFAULT_ALLOW_CLASSES) {
            this.addAllowClassPattern(defaultAllowClassPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllowClassPattern(String classNamePattern) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allowClassPatterns == null) {
                this.allowClassPatterns = new HashMap<String, Pattern>();
            }
            this.allowClassPatterns.put(classNamePattern, Pattern.compile(classNamePattern));
            this.clearClassCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllowClassPattern(String classNamePattern) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allowClassPatterns != null) {
                this.allowClassPatterns.remove(classNamePattern);
            }
            this.clearClassCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisallowClassPattern(String classNamePattern) {
        Object object = this.lock;
        synchronized (object) {
            if (this.disallowClassPatterns == null) {
                this.disallowClassPatterns = new HashMap<String, Pattern>();
            }
            this.disallowClassPatterns.put(classNamePattern, Pattern.compile(classNamePattern));
            this.clearClassCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisallowClassPattern(String classNamePattern) {
        Object object = this.lock;
        synchronized (object) {
            if (this.disallowClassPatterns != null) {
                this.disallowClassPatterns.remove(classNamePattern);
            }
            this.clearClassCache();
        }
    }

    @Override
    public boolean validateAssignment(Object instance, int index, Object value) {
        return true;
    }

    @Override
    public boolean validateAssignment(Object instance, String propertyName, Object value) {
        return true;
    }

    @Override
    public boolean validateCreation(Class<?> c) {
        String className;
        String string = className = c == null ? null : c.getName();
        if (className == null) {
            return true;
        }
        if (this.disallowClasses != null && this.disallowClasses.contains(className)) {
            return false;
        }
        if (this.allowClasses != null && this.allowClasses.contains(className)) {
            return true;
        }
        if (this.disallowClassPatterns != null && !this.disallowClassPatterns.isEmpty()) {
            for (Pattern pattern : this.disallowClassPatterns.values()) {
                if (!pattern.matcher(className).matches()) continue;
                this.addDisallowClass(className);
                return false;
            }
        }
        if (this.allowClassPatterns != null && !this.allowClassPatterns.isEmpty()) {
            for (Pattern pattern : this.allowClassPatterns.values()) {
                if (!pattern.matcher(className).matches()) continue;
                this.addAllowClass(className);
                return true;
            }
            this.addDisallowClass(className);
            return false;
        }
        this.addAllowClass(className);
        return true;
    }

    @Override
    public void initialize(String id, ConfigMap properties) {
        List names;
        ConfigMap disallowedClassesMap;
        List names2;
        if (properties == null || properties.size() == 0) {
            return;
        }
        ConfigMap allowedClassesMap = properties.getPropertyAsMap(PROPERTY_ALLOW_CLASSES, null);
        if (allowedClassesMap != null && !allowedClassesMap.isEmpty() && (names2 = allowedClassesMap.getPropertyAsList(PROPERTY_CLASS_ATTR, null)) != null && !names2.isEmpty()) {
            for (Object element : names2) {
                String name = ((ConfigMap)element).getProperty(PROPERTY_NAME_ATTR);
                this.addAllowClassPattern(name);
            }
        }
        if ((disallowedClassesMap = properties.getPropertyAsMap(PROPERTY_DISALLOW_CLASSES, null)) != null && !disallowedClassesMap.isEmpty() && (names = disallowedClassesMap.getPropertyAsList(PROPERTY_CLASS_ATTR, null)) != null && !names.isEmpty()) {
            for (Object element : names) {
                String name = ((ConfigMap)element).getProperty(PROPERTY_NAME_ATTR);
                this.addDisallowClassPattern(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAllowClass(String className) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allowClasses == null) {
                this.allowClasses = new HashSet<String>();
            }
            if (!this.allowClasses.contains(className)) {
                this.allowClasses.add(className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDisallowClass(String className) {
        Object object = this.lock;
        synchronized (object) {
            if (this.disallowClasses == null) {
                this.disallowClasses = new HashSet<String>();
            }
            if (!this.disallowClasses.contains(className)) {
                this.disallowClasses.add(className);
            }
        }
    }

    protected void clearClassCache() {
        if (this.allowClasses != null) {
            this.allowClasses.clear();
        }
        if (this.disallowClasses != null) {
            this.disallowClasses.clear();
        }
    }
}

