/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.SinglePostCompleteSubscriber;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public final class FlowableMapNotification<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends R> onNextMapper;
    final Function<? super Throwable, ? extends R> onErrorMapper;
    final Supplier<? extends R> onCompleteSupplier;

    public FlowableMapNotification(Flowable<T> source, Function<? super T, ? extends R> onNextMapper, Function<? super Throwable, ? extends R> onErrorMapper, Supplier<? extends R> onCompleteSupplier) {
        super(source);
        this.onNextMapper = onNextMapper;
        this.onErrorMapper = onErrorMapper;
        this.onCompleteSupplier = onCompleteSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new MapNotificationSubscriber<T, R>(s, this.onNextMapper, this.onErrorMapper, this.onCompleteSupplier));
    }

    static final class MapNotificationSubscriber<T, R>
    extends SinglePostCompleteSubscriber<T, R> {
        private static final long serialVersionUID = 2757120512858778108L;
        final Function<? super T, ? extends R> onNextMapper;
        final Function<? super Throwable, ? extends R> onErrorMapper;
        final Supplier<? extends R> onCompleteSupplier;

        MapNotificationSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends R> onNextMapper, Function<? super Throwable, ? extends R> onErrorMapper, Supplier<? extends R> onCompleteSupplier) {
            super(actual);
            this.onNextMapper = onNextMapper;
            this.onErrorMapper = onErrorMapper;
            this.onCompleteSupplier = onCompleteSupplier;
        }

        public void onNext(T t) {
            R p;
            try {
                p = Objects.requireNonNull(this.onNextMapper.apply(t), "The onNext publisher returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(e);
                return;
            }
            ++this.produced;
            this.downstream.onNext(p);
        }

        public void onError(Throwable t) {
            R p;
            try {
                p = Objects.requireNonNull(this.onErrorMapper.apply(t), "The onError publisher returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError((Throwable)new CompositeException(t, e));
                return;
            }
            this.complete(p);
        }

        public void onComplete() {
            R p;
            try {
                p = Objects.requireNonNull(this.onCompleteSupplier.get(), "The onComplete publisher returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(e);
                return;
            }
            this.complete(p);
        }
    }
}

