/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.support.BasicAsyncServerExpectationDecorator;
import org.apache.hc.core5.http.nio.support.DefaultAsyncResponseExchangeHandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.H2Processors;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.testing.nio.HttpTestServer;
import org.apache.hc.core5.testing.nio.InternalServerProtocolNegotiationStarter;
import org.apache.hc.core5.testing.nio.LoggingExceptionCallback;

public class H2TestServer
extends HttpTestServer {
    private H2Config h2Config;
    private Http1Config http1Config;

    public H2TestServer(IOReactorConfig ioReactorConfig, SSLContext sslContext, SSLSessionInitializer sslSessionInitializer, SSLSessionVerifier sslSessionVerifier) throws IOException {
        super(ioReactorConfig, sslContext, sslSessionInitializer, sslSessionVerifier);
    }

    public H2TestServer() throws IOException {
        this(IOReactorConfig.DEFAULT, null, null, null);
    }

    public void configure(H2Config h2Config) {
        this.ensureNotRunning();
        this.h2Config = h2Config;
        this.http1Config = null;
    }

    public void configure(Http1Config http1Config) {
        this.ensureNotRunning();
        this.http1Config = http1Config;
        this.h2Config = null;
    }

    @Override
    public void configure(HttpProcessor httpProcessor) {
        this.ensureNotRunning();
        this.httpProcessor = httpProcessor;
    }

    @Override
    public void configure(Decorator<AsyncServerExchangeHandler> exchangeHandlerDecorator) {
        this.ensureNotRunning();
        this.exchangeHandlerDecorator = exchangeHandlerDecorator;
    }

    @Deprecated
    public void start(IOEventHandlerFactory handlerFactory) throws IOException {
        this.execute(handlerFactory);
    }

    @Deprecated
    public InetSocketAddress start(HttpProcessor httpProcessor, Decorator<AsyncServerExchangeHandler> exchangeHandlerDecorator, Http1Config http1Config) throws Exception {
        this.configure(http1Config);
        this.configure(exchangeHandlerDecorator);
        this.configure(httpProcessor);
        return this.start();
    }

    @Deprecated
    public InetSocketAddress start(HttpProcessor httpProcessor, Decorator<AsyncServerExchangeHandler> exchangeHandlerDecorator, H2Config h2Config) throws Exception {
        this.configure(h2Config);
        this.configure(exchangeHandlerDecorator);
        this.configure(httpProcessor);
        return this.start();
    }

    @Deprecated
    public InetSocketAddress start(HttpProcessor httpProcessor, Http1Config http1Config) throws Exception {
        this.configure(http1Config);
        this.configure(httpProcessor);
        return this.start();
    }

    @Deprecated
    public InetSocketAddress start(H2Config h2Config) throws Exception {
        this.configure(h2Config);
        return this.start();
    }

    @Deprecated
    public InetSocketAddress start(Http1Config http1Config) throws Exception {
        this.configure(http1Config);
        return this.start();
    }

    @Override
    public InetSocketAddress start() throws Exception {
        if (this.http1Config != null) {
            return this.startExecution(new InternalServerProtocolNegotiationStarter(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), (HandlerFactory<AsyncServerExchangeHandler>)new DefaultAsyncResponseExchangeHandlerFactory((HttpRequestMapper)RequestRouter.create((URIAuthority)RequestRouter.LOCAL_AUTHORITY, (UriPatternType)UriPatternType.URI_PATTERN, (List)this.routeEntries, (BiFunction)RequestRouter.LOCAL_AUTHORITY_RESOLVER, null), this.exchangeHandlerDecorator != null ? this.exchangeHandlerDecorator : BasicAsyncServerExpectationDecorator::new), HttpVersionPolicy.FORCE_HTTP_1, H2Config.DEFAULT, this.http1Config, CharCodingConfig.DEFAULT, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier, LoggingExceptionCallback.INSTANCE));
        }
        return this.startExecution(new InternalServerProtocolNegotiationStarter(this.httpProcessor != null ? this.httpProcessor : H2Processors.server(), (HandlerFactory<AsyncServerExchangeHandler>)new DefaultAsyncResponseExchangeHandlerFactory((HttpRequestMapper)RequestRouter.create((URIAuthority)RequestRouter.LOCAL_AUTHORITY, (UriPatternType)UriPatternType.URI_PATTERN, (List)this.routeEntries, (BiFunction)RequestRouter.LOCAL_AUTHORITY_RESOLVER, null), this.exchangeHandlerDecorator != null ? this.exchangeHandlerDecorator : BasicAsyncServerExpectationDecorator::new), HttpVersionPolicy.FORCE_HTTP_2, this.h2Config, Http1Config.DEFAULT, CharCodingConfig.DEFAULT, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier, LoggingExceptionCallback.INSTANCE));
    }
}

