/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.RelBuilder;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlToRelConvertor
extends SqlToRelConverter {
    public IgniteSqlToRelConvertor(RelOptTable.ViewExpander viewExpander, @Nullable SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, SqlToRelConverter.Config cfg) {
        super(viewExpander, validator, catalogReader, cluster, convertletTable, cfg);
    }

    protected RelRoot convertQueryRecursive(SqlNode qry, boolean top, @Nullable RelDataType targetRowType) {
        if (qry.getKind() == SqlKind.MERGE) {
            return RelRoot.of((RelNode)this.convertMerge((SqlMerge)qry), (SqlKind)qry.getKind());
        }
        return super.convertQueryRecursive(qry, top, targetRowType);
    }

    private RelNode convertMerge(SqlMerge call) {
        RelOptTable targetTable = this.getTargetTable((SqlNode)call);
        ArrayList<String> targetColumnNameList = new ArrayList<String>();
        RelDataType targetRowType = targetTable.getRowType();
        SqlUpdate updateCall = call.getUpdateCall();
        if (updateCall != null) {
            for (SqlNode targetColumn : updateCall.getTargetColumnList()) {
                SqlIdentifier id = (SqlIdentifier)targetColumn;
                RelDataTypeField field = SqlValidatorUtil.getTargetField((RelDataType)targetRowType, (RelDataTypeFactory)this.typeFactory, (SqlIdentifier)id, (SqlValidatorCatalogReader)this.catalogReader, (RelOptTable)targetTable);
                assert (field != null) : "column " + id.toString() + " not found";
                targetColumnNameList.add(field.getName());
            }
        }
        RelNode mergeSourceRel = this.convertSelect(Objects.requireNonNull(call.getSourceSelect(), () -> "sourceSelect for " + call), false);
        SqlInsert insertCall = call.getInsertCall();
        int numLevel1Exprs = 0;
        List level1InsertExprs = null;
        List level2InsertExprs = null;
        if (insertCall != null) {
            RelNode insertRel = this.convertInsert(insertCall);
            level1InsertExprs = ((LogicalProject)insertRel.getInput(0)).getProjects();
            if (insertRel.getInput(0).getInput(0) instanceof LogicalProject) {
                level2InsertExprs = ((LogicalProject)insertRel.getInput(0).getInput(0)).getProjects();
            }
            numLevel1Exprs = level1InsertExprs.size();
        }
        LogicalJoin join = (LogicalJoin)mergeSourceRel.getInput(0);
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (int level1Idx = 0; level1Idx < numLevel1Exprs; ++level1Idx) {
            Objects.requireNonNull(level1InsertExprs, "level1InsertExprs");
            if (level2InsertExprs != null && level1InsertExprs.get(level1Idx) instanceof RexInputRef) {
                int level2Idx = ((RexInputRef)level1InsertExprs.get(level1Idx)).getIndex();
                projects.add((RexNode)level2InsertExprs.get(level2Idx));
                continue;
            }
            projects.add((RexNode)level1InsertExprs.get(level1Idx));
        }
        if (updateCall != null) {
            LogicalProject project = (LogicalProject)mergeSourceRel;
            projects.addAll(project.getProjects());
        } else {
            join = join.copy(join.getTraitSet(), join.getCondition(), join.getLeft(), join.getRight(), JoinRelType.ANTI, false);
        }
        RelBuilder relBuilder = this.config.getRelBuilderFactory().create(this.cluster, null).transform(this.config.getRelBuilderConfigTransform());
        relBuilder.push((RelNode)join).project(projects);
        return LogicalTableModify.create((RelOptTable)targetTable, (Prepare.CatalogReader)this.catalogReader, (RelNode)relBuilder.build(), (TableModify.Operation)TableModify.Operation.MERGE, targetColumnNameList, null, (boolean)false);
    }
}

