/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.property;

import java.util.Map;
import org.apache.ignite.internal.sql.engine.property.PropertiesHolder;
import org.apache.ignite.internal.sql.engine.property.Property;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.jetbrains.annotations.Nullable;

class PropertiesHolderImpl
implements PropertiesHolder {
    private final Map<Property<?>, Object> props;

    PropertiesHolderImpl(Map<Property<?>, Object> props) {
        this.props = Map.copyOf(props);
    }

    @Override
    @Nullable
    public <T> T get(Property<T> prop) {
        Object val = this.props.get(prop);
        if (val == null) {
            return null;
        }
        assert (prop.cls.isAssignableFrom(val.getClass())) : IgniteStringFormatter.format((String)"Unexpected property value [name={}, expCls={}, actCls={}, val={}]", (Object[])new Object[]{prop.name, prop.cls, val.getClass(), val});
        return (T)prop.cls.cast(val);
    }

    @Override
    @Nullable
    public <T> T getOrDefault(Property<T> prop, @Nullable T defaultValue) {
        T val = this.get(prop);
        return val == null ? defaultValue : val;
    }

    @Override
    public int size() {
        return this.props.size();
    }

    @Override
    public Map<Property<?>, Object> toMap() {
        return this.props;
    }
}

