/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.row.InternalTuple;
import org.apache.ignite.internal.tostring.S;

public abstract class NativeTypeSpec
extends Enum<NativeTypeSpec> {
    public static final /* enum */ NativeTypeSpec INT8 = new NativeTypeSpec("int8", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.byteValueBoxed(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec INT16 = new NativeTypeSpec("int16", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.shortValueBoxed(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec INT32 = new NativeTypeSpec("int32", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.intValueBoxed(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec INT64 = new NativeTypeSpec("int64", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.longValueBoxed(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec FLOAT = new NativeTypeSpec("float", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.floatValueBoxed(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec DOUBLE = new NativeTypeSpec("double", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.doubleValueBoxed(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec DECIMAL = new NativeTypeSpec("decimal", false){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.decimalValue(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec UUID = new NativeTypeSpec("uuid", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.uuidValue(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec STRING = new NativeTypeSpec("string", false){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.stringValue(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec BYTES = new NativeTypeSpec("blob", false){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.bytesValue(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec BITMASK = new NativeTypeSpec("bitmask", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.bitmaskValue(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec NUMBER = new NativeTypeSpec("number", false){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.numberValue(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec DATE = new NativeTypeSpec("date", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.dateValue(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec TIME = new NativeTypeSpec("time", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.timeValue(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec DATETIME = new NativeTypeSpec("datetime", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.dateTimeValue(colIdx);
        }
    };
    public static final /* enum */ NativeTypeSpec TIMESTAMP = new NativeTypeSpec("timestamp", true){

        @Override
        public Object objectValue(InternalTuple tup, int colIdx) {
            return tup.timestampValue(colIdx);
        }
    };
    private final boolean fixedSize;
    private final String desc;
    private static final /* synthetic */ NativeTypeSpec[] $VALUES;

    public static NativeTypeSpec[] values() {
        return (NativeTypeSpec[])$VALUES.clone();
    }

    public static NativeTypeSpec valueOf(String name) {
        return Enum.valueOf(NativeTypeSpec.class, name);
    }

    private NativeTypeSpec(String desc, boolean fixedSize) {
        this.desc = desc;
        this.fixedSize = fixedSize;
    }

    public boolean fixedLength() {
        return this.fixedSize;
    }

    public abstract Object objectValue(InternalTuple var1, int var2) throws InvalidTypeException;

    public static NativeTypeSpec fromClass(Class<?> cls) {
        assert (cls != null);
        if (cls == Byte.TYPE) {
            return INT8;
        }
        if (cls == Short.TYPE) {
            return INT16;
        }
        if (cls == Integer.TYPE) {
            return INT32;
        }
        if (cls == Long.TYPE) {
            return INT64;
        }
        if (cls == Float.TYPE) {
            return FLOAT;
        }
        if (cls == Double.TYPE) {
            return DOUBLE;
        }
        if (cls == Byte.class) {
            return INT8;
        }
        if (cls == Short.class) {
            return INT16;
        }
        if (cls == Integer.class) {
            return INT32;
        }
        if (cls == Long.class) {
            return INT64;
        }
        if (cls == Float.class) {
            return FLOAT;
        }
        if (cls == Double.class) {
            return DOUBLE;
        }
        if (cls == LocalDate.class) {
            return DATE;
        }
        if (cls == LocalTime.class) {
            return TIME;
        }
        if (cls == LocalDateTime.class) {
            return DATETIME;
        }
        if (cls == Instant.class) {
            return TIMESTAMP;
        }
        if (cls == byte[].class) {
            return BYTES;
        }
        if (cls == String.class) {
            return STRING;
        }
        if (cls == UUID.class) {
            return UUID;
        }
        if (cls == BitSet.class) {
            return BITMASK;
        }
        if (cls == BigInteger.class) {
            return NUMBER;
        }
        if (cls == BigDecimal.class) {
            return DECIMAL;
        }
        return null;
    }

    public static Class<?> toClass(NativeTypeSpec spec, boolean nullable) {
        assert (spec != null);
        switch (spec) {
            case INT8: {
                return nullable ? Byte.class : Byte.TYPE;
            }
            case INT16: {
                return nullable ? Short.class : Short.TYPE;
            }
            case INT32: {
                return nullable ? Integer.class : Integer.TYPE;
            }
            case INT64: {
                return nullable ? Long.class : Long.TYPE;
            }
            case FLOAT: {
                return nullable ? Float.class : Float.TYPE;
            }
            case DOUBLE: {
                return nullable ? Double.class : Double.TYPE;
            }
            case BITMASK: {
                return BitSet.class;
            }
            case BYTES: {
                return byte[].class;
            }
            case STRING: {
                return String.class;
            }
            case DATE: {
                return LocalDate.class;
            }
            case TIME: {
                return LocalTime.class;
            }
            case TIMESTAMP: {
                return Instant.class;
            }
            case DATETIME: {
                return LocalDateTime.class;
            }
            case UUID: {
                return UUID.class;
            }
            case NUMBER: {
                return BigInteger.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
        }
        throw new IllegalStateException("Unknown typeSpec " + spec);
    }

    public static NativeTypeSpec fromObject(Object val) {
        return val != null ? NativeTypeSpec.fromClass(val.getClass()) : null;
    }

    public String toString() {
        return S.toString((String)NativeTypeSpec.class.getSimpleName(), (String)"name", (Object)this.name(), (String)"fixed", (Object)this.fixedLength());
    }

    static {
        $VALUES = new NativeTypeSpec[]{INT8, INT16, INT32, INT64, FLOAT, DOUBLE, DECIMAL, UUID, STRING, BYTES, BITMASK, NUMBER, DATE, TIME, DATETIME, TIMESTAMP};
    }
}

