/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.UnboundMetadata;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.QueryCancel;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTraitDef;
import org.apache.ignite.internal.sql.engine.trait.DistributionTraitDef;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTraitDef;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.AbstractQueryContext;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.ArrayUtils;

public final class BaseQueryContext
extends AbstractQueryContext {
    public static final CalciteConnectionConfig CALCITE_CONNECTION_CONFIG;
    public static final RelOptCluster CLUSTER;
    private static final IgniteTypeFactory TYPE_FACTORY;
    private static final IgniteCostFactory COST_FACTORY;
    private static final BaseQueryContext EMPTY_CONTEXT;
    private static final VolcanoPlanner DUMMY_PLANNER;
    private static final RexBuilder DFLT_REX_BUILDER;
    private final FrameworkConfig cfg;
    private final IgniteLogger log;
    private final IgniteTypeFactory typeFactory;
    private final RexBuilder rexBuilder;
    private final QueryCancel cancel;
    private final UUID queryId;
    private final Object[] parameters;
    private final InternalTransaction tx;
    private final HybridTimestamp txTs;
    private CalciteCatalogReader catalogReader;
    private long plannerTimeout;

    private BaseQueryContext(UUID queryId, FrameworkConfig cfg, QueryCancel cancel, Object[] parameters, IgniteLogger log, InternalTransaction tx, HybridTimestamp txTs, long plannerTimeout) {
        super(Contexts.chain((Context[])new Context[]{cfg.getContext()}));
        this.cfg = Frameworks.newConfigBuilder((FrameworkConfig)cfg).context((Context)this).build();
        this.queryId = queryId;
        this.log = log;
        this.cancel = cancel;
        this.parameters = parameters;
        this.tx = tx;
        this.txTs = txTs;
        this.plannerTimeout = plannerTimeout;
        RelDataTypeSystem typeSys = (RelDataTypeSystem)CALCITE_CONNECTION_CONFIG.typeSystem(RelDataTypeSystem.class, (Object)cfg.getTypeSystem());
        this.typeFactory = new IgniteTypeFactory(typeSys);
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BaseQueryContext empty() {
        return EMPTY_CONTEXT;
    }

    public UUID queryId() {
        return this.queryId;
    }

    public Object[] parameters() {
        return this.parameters;
    }

    public FrameworkConfig config() {
        return this.cfg;
    }

    public IgniteLogger logger() {
        return this.log;
    }

    public String schemaName() {
        return this.schema().getName();
    }

    public SchemaPlus schema() {
        return this.cfg.getDefaultSchema();
    }

    public IgniteTypeFactory typeFactory() {
        return this.typeFactory;
    }

    public RexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    public InternalTransaction transaction() {
        return this.tx;
    }

    public HybridTimestamp transactionTime() {
        return this.txTs;
    }

    public long plannerTimeout() {
        return this.plannerTimeout;
    }

    public CalciteCatalogReader catalogReader() {
        SchemaPlus dfltSchema;
        if (this.catalogReader != null) {
            return this.catalogReader;
        }
        SchemaPlus rootSchema = dfltSchema = this.schema();
        while (rootSchema.getParentSchema() != null) {
            rootSchema = rootSchema.getParentSchema();
        }
        this.catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)rootSchema), CalciteSchema.from((SchemaPlus)dfltSchema).path(null), (RelDataTypeFactory)this.typeFactory(), CALCITE_CONNECTION_CONFIG);
        return this.catalogReader;
    }

    public QueryCancel cancel() {
        return this.cancel;
    }

    public Builder toBuilder() {
        return BaseQueryContext.builder().queryId(this.queryId).frameworkConfig(this.cfg).logger(this.log).cancel(this.cancel).parameters(this.parameters).transaction(this.tx).transactionTime(this.txTs);
    }

    static {
        COST_FACTORY = new IgniteCostFactory();
        Properties props = new Properties();
        props.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(Commons.FRAMEWORK_CONFIG.getParserConfig().caseSensitive()));
        props.setProperty(CalciteConnectionProperty.CONFORMANCE.camelName(), String.valueOf(Commons.FRAMEWORK_CONFIG.getParserConfig().conformance()));
        props.setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), String.valueOf(true));
        CALCITE_CONNECTION_CONFIG = new CalciteConnectionConfigImpl(props);
        EMPTY_CONTEXT = BaseQueryContext.builder().build();
        DUMMY_PLANNER = new VolcanoPlanner(COST_FACTORY, EMPTY_CONTEXT){

            public void registerSchema(RelOptSchema schema) {
            }
        };
        for (RelTraitDef def : EMPTY_CONTEXT.config().getTraitDefs()) {
            DUMMY_PLANNER.addRelTraitDef(def);
        }
        RelDataTypeSystem typeSys = (RelDataTypeSystem)CALCITE_CONNECTION_CONFIG.typeSystem(RelDataTypeSystem.class, (Object)Commons.FRAMEWORK_CONFIG.getTypeSystem());
        TYPE_FACTORY = new IgniteTypeFactory(typeSys);
        DFLT_REX_BUILDER = new RexBuilder((RelDataTypeFactory)TYPE_FACTORY);
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)DUMMY_PLANNER, (RexBuilder)DFLT_REX_BUILDER);
        final String cantBeUsedMsg = "Empty cluster can't be used for planning or mapping";
        cluster.setMetadataProvider(new RelMetadataProvider(){

            public <M extends Metadata> UnboundMetadata<M> apply(Class<? extends RelNode> relCls, Class<? extends M> metadataCls) {
                throw new AssertionError((Object)cantBeUsedMsg);
            }

            public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
                throw new AssertionError((Object)cantBeUsedMsg);
            }

            public List<MetadataHandler<?>> handlers(Class<? extends MetadataHandler<?>> hndCls) {
                throw new AssertionError((Object)cantBeUsedMsg);
            }
        });
        cluster.setMetadataQuerySupplier(() -> {
            throw new AssertionError((Object)cantBeUsedMsg);
        });
        CLUSTER = cluster;
    }

    public static class Builder {
        private static final FrameworkConfig EMPTY_CONFIG = Frameworks.newConfigBuilder((FrameworkConfig)Commons.FRAMEWORK_CONFIG).defaultSchema(Frameworks.createRootSchema((boolean)false)).traitDefs(new RelTraitDef[]{ConventionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE, DistributionTraitDef.INSTANCE, RewindabilityTraitDef.INSTANCE, CorrelationTraitDef.INSTANCE}).build();
        private FrameworkConfig frameworkCfg = EMPTY_CONFIG;
        private QueryCancel cancel = new QueryCancel();
        private IgniteLogger log = Loggers.voidLogger();
        private UUID queryId = UUID.randomUUID();
        private Object[] parameters = ArrayUtils.OBJECT_EMPTY_ARRAY;
        private InternalTransaction tx;
        private HybridTimestamp txTs;
        private long plannerTimeout;

        public Builder frameworkConfig(FrameworkConfig frameworkCfg) {
            this.frameworkCfg = Objects.requireNonNull(frameworkCfg);
            return this;
        }

        public Builder cancel(QueryCancel cancel) {
            this.cancel = Objects.requireNonNull(cancel);
            return this;
        }

        public Builder logger(IgniteLogger log) {
            this.log = Objects.requireNonNull(log);
            return this;
        }

        public Builder queryId(UUID queryId) {
            this.queryId = Objects.requireNonNull(queryId);
            return this;
        }

        public Builder parameters(Object ... parameters) {
            this.parameters = Objects.requireNonNull(parameters);
            return this;
        }

        public Builder transaction(InternalTransaction tx) {
            this.tx = tx;
            return this;
        }

        public Builder transactionTime(HybridTimestamp txTs) {
            this.txTs = txTs;
            return this;
        }

        public Builder plannerTimeout(long plannerTimeout) {
            this.plannerTimeout = plannerTimeout;
            return this;
        }

        public BaseQueryContext build() {
            return new BaseQueryContext(this.queryId, this.frameworkCfg, this.cancel, this.parameters, this.log, this.tx, this.txTs, this.plannerTimeout);
        }
    }
}

