/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.client;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.common.MetaStorageException;
import org.apache.ignite.internal.metastorage.common.command.cursor.CursorCloseCommand;
import org.apache.ignite.internal.metastorage.common.command.cursor.CursorHasNextCommand;
import org.apache.ignite.internal.metastorage.common.command.cursor.CursorNextCommand;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.raft.client.Command;
import org.apache.ignite.raft.client.service.RaftGroupService;
import org.jetbrains.annotations.Nullable;

public class CursorImpl<T>
implements Cursor<T> {
    private static final IgniteLogger LOG = Loggers.forClass(CursorImpl.class);
    private final CompletableFuture<IgniteUuid> initOp;
    private final RaftGroupService metaStorageRaftGrpSvc;
    private final Iterator<T> it;

    CursorImpl(RaftGroupService metaStorageRaftGrpSvc, CompletableFuture<IgniteUuid> initOp, Function<Object, Object> fn) {
        this.metaStorageRaftGrpSvc = metaStorageRaftGrpSvc;
        this.initOp = initOp;
        this.it = new InnerIterator(fn);
    }

    public void close() {
        try {
            ((CompletableFuture)this.initOp.thenCompose(cursorId -> this.metaStorageRaftGrpSvc.run((Command)new CursorCloseCommand(cursorId)))).get();
            ((InnerIterator)this.it).close();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof NodeStoppingException) {
                return;
            }
            LOG.debug("Unable to evaluate cursor close command", (Throwable)e);
            throw (MetaStorageException)ExceptionUtils.withCauseAndCode(MetaStorageException::new, (int)ErrorGroups.MetaStorage.CURSOR_CLOSING_ERR, (Throwable)e);
        }
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public T next() {
        return this.it.next();
    }

    private class InnerIterator
    implements Iterator<T> {
        private final Function<Object, Object> fn;
        @Nullable
        private Iterator<T> internalCacheIterator;

        public InnerIterator(Function<Object, Object> fn) {
            this.fn = fn;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.internalCacheIterator != null && this.internalCacheIterator.hasNext()) {
                    return true;
                }
                return (Boolean)((CompletableFuture)CursorImpl.this.initOp.thenCompose(cursorId -> CursorImpl.this.metaStorageRaftGrpSvc.run((Command)new CursorHasNextCommand(cursorId)))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof NodeStoppingException) {
                    return false;
                }
                LOG.debug("Unable to evaluate cursor hasNext command", (Throwable)e);
                throw (MetaStorageException)ExceptionUtils.withCauseAndCode(MetaStorageException::new, (int)ErrorGroups.MetaStorage.CURSOR_EXECUTION_ERR, (Throwable)e);
            }
        }

        @Override
        public T next() {
            try {
                if (this.internalCacheIterator != null && this.internalCacheIterator.hasNext()) {
                    return this.internalCacheIterator.next();
                }
                Object res = ((CompletableFuture)CursorImpl.this.initOp.thenCompose(cursorId -> CursorImpl.this.metaStorageRaftGrpSvc.run((Command)new CursorNextCommand(cursorId)))).get();
                Object transformed = this.fn.apply(res);
                if (transformed instanceof Iterable) {
                    this.internalCacheIterator = ((Iterable)transformed).iterator();
                    return this.internalCacheIterator.next();
                }
                return transformed;
            }
            catch (InterruptedException | ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof NodeStoppingException) {
                    throw new NoSuchElementException();
                }
                if (cause instanceof NoSuchElementException) {
                    throw (NoSuchElementException)cause;
                }
                LOG.debug("Unable to evaluate cursor hasNext command", (Throwable)e);
                throw (MetaStorageException)ExceptionUtils.withCauseAndCode(MetaStorageException::new, (int)ErrorGroups.MetaStorage.CURSOR_EXECUTION_ERR, (Throwable)e);
            }
        }

        public void close() {
            this.internalCacheIterator = null;
        }
    }
}

