/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.ReadIndexResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

class ReadIndexResponseDeserializer
implements MessageDeserializer<RpcRequests.ReadIndexResponse> {
    private final ReadIndexResponseBuilder msg;

    ReadIndexResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.readIndexResponse();
    }

    public Class<RpcRequests.ReadIndexResponse> klass() {
        return RpcRequests.ReadIndexResponse.class;
    }

    public RpcRequests.ReadIndexResponse getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.index(reader.readLong("index"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.success(reader.readBoolean("success"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.ReadIndexResponse.class);
    }
}

