/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;

public class SafeTimeCandidateManager {
    private final PendingComparableValuesTracker<HybridTimestamp> safeTimeTracker;
    private final Map<Long, Map<Long, HybridTimestamp>> safeTimeCandidates = new ConcurrentHashMap<Long, Map<Long, HybridTimestamp>>();

    public SafeTimeCandidateManager(PendingComparableValuesTracker<HybridTimestamp> safeTimeTracker) {
        this.safeTimeTracker = safeTimeTracker;
    }

    public void addSafeTimeCandidate(long index, long term, HybridTimestamp safeTime) {
        this.safeTimeCandidates.compute(index, (i, candidates) -> {
            if (candidates == null) {
                candidates = new HashMap<Long, HybridTimestamp>();
            }
            candidates.put(term, safeTime);
            return candidates;
        });
    }

    public void commitIndex(long prevIndex, long index, long term) {
        for (long currentIndex = prevIndex + 1L; currentIndex <= index; ++currentIndex) {
            Map<Long, HybridTimestamp> candidates = this.safeTimeCandidates.remove(currentIndex);
            if (candidates == null) continue;
            HybridTimestamp safeTime = null;
            for (Map.Entry<Long, HybridTimestamp> e : candidates.entrySet()) {
                if (e.getKey() != term) continue;
                safeTime = e.getValue();
            }
            assert (safeTime != null);
            this.safeTimeTracker.update(safeTime);
        }
    }
}

