/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.network.serialization.BuiltInType;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.DescriptorRegistry;
import org.apache.ignite.internal.network.serialization.Null;
import org.jetbrains.annotations.Nullable;

public class ClassDescriptorRegistry
implements DescriptorRegistry {
    private static final int BUILTIN_DESCRIPTORS_OFFSET_COUNT = 200;
    private final AtomicInteger idGenerator = new AtomicInteger(200);
    private final ConcurrentMap<Class<?>, Integer> idMap = new ConcurrentHashMap();
    private final ConcurrentMap<Integer, ClassDescriptor> descriptorMap = new ConcurrentHashMap<Integer, ClassDescriptor>();

    public ClassDescriptorRegistry() {
        for (BuiltInType value : BuiltInType.values()) {
            this.addPredefinedDescriptor(value.clazz(), value.asClassDescriptor());
        }
    }

    private void addPredefinedDescriptor(Class<?> clazz, ClassDescriptor descriptor) {
        int descriptorId = descriptor.descriptorId();
        Integer existingId = this.idMap.put(clazz, descriptorId);
        assert (existingId == null) : clazz;
        ClassDescriptor existingDescriptor = this.descriptorMap.put(descriptorId, descriptor);
        assert (existingDescriptor == null);
    }

    public int getId(Class<?> clazz) {
        return this.idMap.computeIfAbsent(clazz, unused -> this.idGenerator.getAndIncrement());
    }

    @Override
    @Nullable
    public ClassDescriptor getDescriptor(int descriptorId) {
        return (ClassDescriptor)this.descriptorMap.get(descriptorId);
    }

    @Override
    @Nullable
    public ClassDescriptor getDescriptor(Class<?> clazz) {
        Integer descriptorId = (Integer)this.idMap.get(clazz);
        if (descriptorId == null) {
            return null;
        }
        return (ClassDescriptor)this.descriptorMap.get(descriptorId);
    }

    public ClassDescriptor getNullDescriptor() {
        return this.getRequiredDescriptor(Null.class);
    }

    void addDescriptor(Class<?> clazz, ClassDescriptor descriptor) {
        assert (clazz.getName().equals(descriptor.className()));
        Integer descriptorId = (Integer)this.idMap.get(clazz);
        assert (descriptorId != null) : "Attempting to store an unregistered descriptor";
        int realDescriptorId = descriptor.descriptorId();
        assert (descriptorId == realDescriptorId) : "Descriptor id doesn't match, registered=" + descriptorId + ", real=" + realDescriptorId;
        this.descriptorMap.put(realDescriptorId, descriptor);
    }

    public static boolean shouldBeBuiltIn(int descriptorId) {
        return descriptorId < 200;
    }
}

