/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite.internal.network.message.FieldDescriptorMessage;
import org.apache.ignite.internal.network.serialization.BuiltInType;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.ClassDescriptorRegistry;
import org.apache.ignite.internal.network.serialization.ClassNameMapBackedClassIndexedDescriptors;
import org.apache.ignite.internal.network.serialization.CompositeDescriptorRegistry;
import org.apache.ignite.internal.network.serialization.FieldDescriptor;
import org.apache.ignite.internal.network.serialization.MapBackedIdIndexedDescriptors;
import org.apache.ignite.internal.network.serialization.Serialization;
import org.apache.ignite.internal.network.serialization.SerializationException;
import org.apache.ignite.internal.network.serialization.SerializationService;
import org.apache.ignite.internal.network.serialization.SerializationType;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageSerializer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PerSessionSerializationService {
    private static final NetworkMessagesFactory MSG_FACTORY = new NetworkMessagesFactory();
    private static final int NO_DESCRIPTOR_ID = Integer.MIN_VALUE;
    private final SerializationService serializationService;
    private final Int2ObjectMap<ClassDescriptor> mergedIdToDescriptorMap = new Int2ObjectOpenHashMap();
    private final Map<String, ClassDescriptor> mergedClassToDescriptorMap = new HashMap<String, ClassDescriptor>();
    private final IntSet sentDescriptors = new IntOpenHashSet();
    private final CompositeDescriptorRegistry descriptors;
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public PerSessionSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
        this.descriptors = new CompositeDescriptorRegistry(new MapBackedIdIndexedDescriptors(this.mergedIdToDescriptorMap), new ClassNameMapBackedClassIndexedDescriptors(this.mergedClassToDescriptorMap), serializationService.getLocalDescriptorRegistry());
    }

    public <T extends NetworkMessage> MessageSerializer<T> createMessageSerializer(short groupType, short messageType) {
        return this.serializationService.createSerializer(groupType, messageType);
    }

    public <T extends NetworkMessage> MessageDeserializer<T> createMessageDeserializer(short groupType, short messageType) {
        return this.serializationService.createDeserializer(groupType, messageType);
    }

    public boolean isDescriptorSent(int descriptorId) {
        return this.sentDescriptors.contains(descriptorId);
    }

    public void addSentDescriptor(int descriptorId) {
        this.sentDescriptors.add(descriptorId);
    }

    public static List<ClassDescriptorMessage> createClassDescriptorsMessages(IntSet descriptorIds, ClassDescriptorRegistry registry) {
        return descriptorIds.intStream().mapToObj(registry::getRequiredDescriptor).filter(descriptor -> !ClassDescriptorRegistry.shouldBeBuiltIn(descriptor.descriptorId())).map(descriptor -> {
            List<FieldDescriptorMessage> fields = descriptor.fields().stream().map(d -> MSG_FACTORY.fieldDescriptorMessage().name(d.name()).typeDescriptorId(d.typeDescriptorId()).className(d.typeName()).flags(PerSessionSerializationService.fieldFlags(d)).build()).collect(Collectors.toList());
            Serialization serialization = descriptor.serialization();
            return MSG_FACTORY.classDescriptorMessage().fields(fields).serializationType((byte)serialization.type().value()).serializationFlags(PerSessionSerializationService.serializationAttributeFlags(serialization)).descriptorId(descriptor.descriptorId()).className(descriptor.className()).superClassDescriptorId(PerSessionSerializationService.superClassDescriptorIdForMessage(descriptor)).superClassName(descriptor.superClassName()).componentTypeDescriptorId(PerSessionSerializationService.componentTypeDescriptorIdForMessage(descriptor)).componentTypeName(descriptor.componentTypeName()).attributes(PerSessionSerializationService.classDescriptorAttributeFlags(descriptor)).build();
        }).collect(Collectors.toList());
    }

    private static byte fieldFlags(FieldDescriptor fieldDescriptor) {
        int bits = PerSessionSerializationService.condMask(fieldDescriptor.isUnshared(), 1) | PerSessionSerializationService.condMask(fieldDescriptor.isPrimitive(), 2) | PerSessionSerializationService.condMask(fieldDescriptor.isRuntimeTypeKnownUpfront(), 4);
        return (byte)bits;
    }

    private static byte serializationAttributeFlags(Serialization serialization) {
        int bits = PerSessionSerializationService.condMask(serialization.hasWriteObject(), 1) | PerSessionSerializationService.condMask(serialization.hasReadObject(), 2) | PerSessionSerializationService.condMask(serialization.hasReadObjectNoData(), 4) | PerSessionSerializationService.condMask(serialization.hasWriteReplace(), 8) | PerSessionSerializationService.condMask(serialization.hasReadResolve(), 16);
        return (byte)bits;
    }

    private static int condMask(boolean value, int mask) {
        return value ? mask : 0;
    }

    private static byte classDescriptorAttributeFlags(ClassDescriptor descriptor) {
        int bits = PerSessionSerializationService.condMask(descriptor.isPrimitive(), 1) | PerSessionSerializationService.condMask(descriptor.isArray(), 2) | PerSessionSerializationService.condMask(descriptor.isRuntimeEnum(), 4) | PerSessionSerializationService.condMask(descriptor.isRuntimeTypeKnownUpfront(), 8);
        return (byte)bits;
    }

    private static int superClassDescriptorIdForMessage(ClassDescriptor descriptor) {
        Integer id = descriptor.superClassDescriptorId();
        if (id == null) {
            return Integer.MIN_VALUE;
        }
        return id;
    }

    private static int componentTypeDescriptorIdForMessage(ClassDescriptor descriptor) {
        Integer id = descriptor.componentTypeDescriptorId();
        if (id == null) {
            return Integer.MIN_VALUE;
        }
        return id;
    }

    public void mergeDescriptors(Collection<ClassDescriptorMessage> remoteDescriptors) {
        List leftToProcess = remoteDescriptors.stream().filter(classMessage -> !this.knownMergedDescriptor(classMessage.descriptorId())).collect(Collectors.toCollection(LinkedList::new));
        while (!leftToProcess.isEmpty()) {
            boolean processedSomethingDuringThisPass = false;
            Iterator it = leftToProcess.iterator();
            while (it.hasNext()) {
                ClassDescriptorMessage classMessage2 = (ClassDescriptorMessage)it.next();
                if (this.knownMergedDescriptor(classMessage2.descriptorId())) {
                    it.remove();
                    continue;
                }
                if (!this.dependenciesAreMerged(classMessage2)) continue;
                ClassDescriptor mergedDescriptor = this.messageToMergedClassDescriptor(classMessage2);
                this.mergedIdToDescriptorMap.put(classMessage2.descriptorId(), (Object)mergedDescriptor);
                this.mergedClassToDescriptorMap.put(classMessage2.className(), mergedDescriptor);
                it.remove();
                processedSomethingDuringThisPass = true;
            }
            if (processedSomethingDuringThisPass || leftToProcess.isEmpty()) continue;
            throw new IllegalStateException("Cannot merge descriptors in the correct order; a cycle? " + leftToProcess);
        }
    }

    private boolean dependenciesAreMerged(ClassDescriptorMessage classMessage) {
        return this.knownMergedDescriptor(classMessage.superClassDescriptorId()) && this.knownMergedDescriptor(classMessage.componentTypeDescriptorId());
    }

    private boolean knownMergedDescriptor(int descriptorId) {
        return ClassDescriptorRegistry.shouldBeBuiltIn(descriptorId) || this.mergedIdToDescriptorMap.containsKey(descriptorId);
    }

    private ClassDescriptor messageToMergedClassDescriptor(ClassDescriptorMessage classMessage) {
        @Nullable Class<?> localClass = this.maybeClassForName(classMessage.className());
        if (localClass != null) {
            return this.buildRemoteDescriptor(classMessage, localClass);
        }
        return this.buildRemoteDescriptor(classMessage);
    }

    private ClassDescriptor buildRemoteDescriptor(ClassDescriptorMessage classMessage, Class<?> localClass) {
        ClassDescriptor localDescriptor = this.serializationService.getOrCreateLocalDescriptor(localClass);
        List<FieldDescriptor> remoteFields = classMessage.fields().stream().map(fieldMessage -> this.fieldDescriptorFromMessage((FieldDescriptorMessage)fieldMessage, localClass)).collect(Collectors.toList());
        Serialization serialization = this.buildSerialization(classMessage);
        return ClassDescriptor.forRemote(localClass, classMessage.descriptorId(), this.remoteSuperClassDescriptor(classMessage), this.remoteComponentTypeDescriptor(classMessage), this.bitValue(classMessage.attributes(), 1), this.bitValue(classMessage.attributes(), 2), this.bitValue(classMessage.attributes(), 4), this.bitValue(classMessage.attributes(), 8), remoteFields, serialization, localDescriptor);
    }

    private ClassDescriptor buildRemoteDescriptor(ClassDescriptorMessage classMessage) {
        List<FieldDescriptor> remoteFields = classMessage.fields().stream().map(fieldMessage -> this.fieldDescriptorFromMessage((FieldDescriptorMessage)fieldMessage, classMessage.className())).collect(Collectors.toList());
        Serialization serialization = this.buildSerialization(classMessage);
        return ClassDescriptor.forRemote(classMessage.className(), classMessage.descriptorId(), this.remoteSuperClassDescriptor(classMessage), this.remoteComponentTypeDescriptor(classMessage), this.bitValue(classMessage.attributes(), 1), this.bitValue(classMessage.attributes(), 2), this.bitValue(classMessage.attributes(), 4), this.bitValue(classMessage.attributes(), 8), remoteFields, serialization);
    }

    private Serialization buildSerialization(ClassDescriptorMessage classMessage) {
        SerializationType serializationType = SerializationType.getByValue(classMessage.serializationType());
        return new Serialization(serializationType, this.bitValue(classMessage.serializationFlags(), 1), this.bitValue(classMessage.serializationFlags(), 2), this.bitValue(classMessage.serializationFlags(), 4), this.bitValue(classMessage.serializationFlags(), 8), this.bitValue(classMessage.serializationFlags(), 16));
    }

    private boolean bitValue(byte flags, int bitMask) {
        return (flags & bitMask) != 0;
    }

    @Nullable
    private ClassDescriptor remoteSuperClassDescriptor(ClassDescriptorMessage clsMsg) {
        if (clsMsg.superClassDescriptorId() == Integer.MIN_VALUE) {
            return null;
        }
        return this.remoteClassDescriptor(clsMsg.superClassDescriptorId(), clsMsg.superClassName());
    }

    @Nullable
    private ClassDescriptor remoteComponentTypeDescriptor(ClassDescriptorMessage clsMsg) {
        if (clsMsg.componentTypeDescriptorId() == Integer.MIN_VALUE) {
            return null;
        }
        return this.remoteClassDescriptor(clsMsg.componentTypeDescriptorId(), clsMsg.componentTypeName());
    }

    private FieldDescriptor fieldDescriptorFromMessage(FieldDescriptorMessage fieldMessage, Class<?> declaringClass) {
        int typeDescriptorId = fieldMessage.typeDescriptorId();
        return FieldDescriptor.remote(fieldMessage.name(), this.fieldType(typeDescriptorId, fieldMessage.className()), typeDescriptorId, this.bitValue(fieldMessage.flags(), 1), this.bitValue(fieldMessage.flags(), 2), this.bitValue(fieldMessage.flags(), 4), declaringClass);
    }

    private FieldDescriptor fieldDescriptorFromMessage(FieldDescriptorMessage fieldMessage, String declaringClassName) {
        int typeDescriptorId = fieldMessage.typeDescriptorId();
        return FieldDescriptor.remote(fieldMessage.name(), this.fieldType(typeDescriptorId, fieldMessage.className()), typeDescriptorId, this.bitValue(fieldMessage.flags(), 1), this.bitValue(fieldMessage.flags(), 2), this.bitValue(fieldMessage.flags(), 4), declaringClassName);
    }

    private ClassDescriptor remoteClassDescriptor(int descriptorId, String typeName) {
        if (ClassDescriptorRegistry.shouldBeBuiltIn(descriptorId)) {
            return this.serializationService.getLocalDescriptor(descriptorId);
        }
        return this.mergedClassToDescriptorMap.get(typeName);
    }

    private Class<?> fieldType(int descriptorId, String typeName) {
        if (ClassDescriptorRegistry.shouldBeBuiltIn(descriptorId)) {
            return BuiltInType.findByDescriptorId(descriptorId).clazz();
        }
        return this.requiredClassForName(typeName);
    }

    private Class<?> requiredClassForName(String className) {
        Class<?> result = this.maybeClassForName(className);
        if (result == null) {
            throw new SerializationException("Class " + className + " is not found");
        }
        return result;
    }

    @Nullable
    private Class<?> maybeClassForName(String className) {
        try {
            return Class.forName(className, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public CompositeDescriptorRegistry compositeDescriptorRegistry() {
        return this.descriptors;
    }

    @TestOnly
    Map<Integer, ClassDescriptor> getDescriptorMapView() {
        return this.mergedIdToDescriptorMap;
    }
}

