/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.raft.server.RaftGroupEventsListener;
import org.apache.ignite.internal.raft.server.RaftGroupOptions;
import org.apache.ignite.internal.raft.server.RaftServer;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.DefaultLogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.IgniteJraftServiceFactory;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.raft.client.Peer;
import org.apache.ignite.raft.client.WriteCommand;
import org.apache.ignite.raft.client.service.CommandClosure;
import org.apache.ignite.raft.client.service.RaftGroupListener;
import org.apache.ignite.raft.jraft.Closure;
import org.apache.ignite.raft.jraft.JRaftUtils;
import org.apache.ignite.raft.jraft.NodeManager;
import org.apache.ignite.raft.jraft.RaftGroupService;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.core.FSMCallerImpl;
import org.apache.ignite.raft.jraft.core.NodeImpl;
import org.apache.ignite.raft.jraft.core.ReadOnlyServiceImpl;
import org.apache.ignite.raft.jraft.core.StateMachineAdapter;
import org.apache.ignite.raft.jraft.disruptor.StripedDisruptor;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.option.NodeOptions;
import org.apache.ignite.raft.jraft.rpc.impl.IgniteRpcClient;
import org.apache.ignite.raft.jraft.rpc.impl.IgniteRpcServer;
import org.apache.ignite.raft.jraft.storage.impl.LogManagerImpl;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotWriter;
import org.apache.ignite.raft.jraft.util.ExecutorServiceHelper;
import org.apache.ignite.raft.jraft.util.ExponentialBackoffTimeoutStrategy;
import org.apache.ignite.raft.jraft.util.JDKMarshaller;
import org.apache.ignite.raft.jraft.util.Utils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JraftServerImpl
implements RaftServer {
    private final ClusterService service;
    private final Path dataPath;
    private final LogStorageFactory logStorageFactory;
    private IgniteRpcServer rpcServer;
    private final ConcurrentMap<ReplicationGroupId, RaftGroupService> groups = new ConcurrentHashMap<ReplicationGroupId, RaftGroupService>();
    private final List<Object> startGroupInProgressMonitors;
    private final NodeManager nodeManager;
    private final NodeOptions opts;
    private ExecutorService requestExecutor;
    private static final int SIMULTANEOUS_GROUP_START_PARALLELISM = Math.min(Utils.cpus() * 3, 25);

    public JraftServerImpl(ClusterService service, Path dataPath) {
        this(service, dataPath, new NodeOptions());
    }

    public JraftServerImpl(ClusterService service, Path dataPath, NodeOptions opts) {
        this.service = service;
        this.dataPath = dataPath;
        this.nodeManager = new NodeManager();
        this.logStorageFactory = new DefaultLogStorageFactory(dataPath.resolve("log"));
        this.opts = opts;
        this.opts.setRpcConnectTimeoutMs(this.opts.getElectionTimeoutMs() / 3);
        this.opts.setRpcDefaultTimeout(this.opts.getElectionTimeoutMs() / 2);
        this.opts.setSharedPools(true);
        if (opts.getServerName() == null) {
            this.opts.setServerName(service.localConfiguration().getName());
        }
        this.opts.setElectionTimeoutStrategy(new ExponentialBackoffTimeoutStrategy(11000, 3L));
        ArrayList<Object> monitors = new ArrayList<Object>(SIMULTANEOUS_GROUP_START_PARALLELISM);
        for (int i = 0; i < SIMULTANEOUS_GROUP_START_PARALLELISM; ++i) {
            monitors.add(new Object());
        }
        this.startGroupInProgressMonitors = Collections.unmodifiableList(monitors);
    }

    public void start() {
        assert (this.opts.isSharedPools()) : "RAFT server is supposed to run in shared pools mode";
        if (this.opts.getCommonExecutor() == null) {
            this.opts.setCommonExecutor(JRaftUtils.createCommonExecutor(this.opts));
        }
        if (this.opts.getStripedExecutor() == null) {
            this.opts.setStripedExecutor(JRaftUtils.createAppendEntriesExecutor(this.opts));
        }
        if (this.opts.getScheduler() == null) {
            this.opts.setScheduler(JRaftUtils.createScheduler(this.opts));
        }
        if (this.opts.getClientExecutor() == null) {
            this.opts.setClientExecutor(JRaftUtils.createClientExecutor(this.opts, this.opts.getServerName()));
        }
        if (this.opts.getVoteTimer() == null) {
            this.opts.setVoteTimer(JRaftUtils.createTimer(this.opts, "JRaft-VoteTimer"));
        }
        if (this.opts.getElectionTimer() == null) {
            this.opts.setElectionTimer(JRaftUtils.createTimer(this.opts, "JRaft-ElectionTimer"));
        }
        if (this.opts.getStepDownTimer() == null) {
            this.opts.setStepDownTimer(JRaftUtils.createTimer(this.opts, "JRaft-StepDownTimer"));
        }
        if (this.opts.getSnapshotTimer() == null) {
            this.opts.setSnapshotTimer(JRaftUtils.createTimer(this.opts, "JRaft-SnapshotTimer"));
        }
        this.requestExecutor = JRaftUtils.createRequestExecutor(this.opts);
        this.rpcServer = new IgniteRpcServer(this.service, this.nodeManager, this.opts.getRaftMessagesFactory(), this.requestExecutor);
        if (this.opts.getfSMCallerExecutorDisruptor() == null) {
            this.opts.setfSMCallerExecutorDisruptor(new StripedDisruptor<FSMCallerImpl.ApplyTask>(NamedThreadFactory.threadPrefix((String)this.opts.getServerName(), (String)"JRaft-FSMCaller-Disruptor"), this.opts.getRaftOptions().getDisruptorBufferSize(), () -> new FSMCallerImpl.ApplyTask(), this.opts.getStripes()));
        }
        if (this.opts.getNodeApplyDisruptor() == null) {
            this.opts.setNodeApplyDisruptor(new StripedDisruptor<NodeImpl.LogEntryAndClosure>(NamedThreadFactory.threadPrefix((String)this.opts.getServerName(), (String)"JRaft-NodeImpl-Disruptor"), this.opts.getRaftOptions().getDisruptorBufferSize(), () -> new NodeImpl.LogEntryAndClosure(), this.opts.getStripes()));
        }
        if (this.opts.getReadOnlyServiceDisruptor() == null) {
            this.opts.setReadOnlyServiceDisruptor(new StripedDisruptor<ReadOnlyServiceImpl.ReadIndexEvent>(NamedThreadFactory.threadPrefix((String)this.opts.getServerName(), (String)"JRaft-ReadOnlyService-Disruptor"), this.opts.getRaftOptions().getDisruptorBufferSize(), () -> new ReadOnlyServiceImpl.ReadIndexEvent(), this.opts.getStripes()));
        }
        if (this.opts.getLogManagerDisruptor() == null) {
            this.opts.setLogManagerDisruptor(new StripedDisruptor<LogManagerImpl.StableClosureEvent>(NamedThreadFactory.threadPrefix((String)this.opts.getServerName(), (String)"JRaft-LogManager-Disruptor"), this.opts.getRaftOptions().getDisruptorBufferSize(), () -> new LogManagerImpl.StableClosureEvent(), this.opts.getStripes()));
        }
        this.logStorageFactory.start();
        this.rpcServer.init(null);
    }

    public void stop() throws Exception {
        assert (this.groups.isEmpty()) : IgniteStringFormatter.format((String)"Raft groups {} are still running on the node {}", (Object[])new Object[]{this.groups.keySet(), this.service.topologyService().localMember().name()});
        this.rpcServer.shutdown();
        if (this.opts.getfSMCallerExecutorDisruptor() != null) {
            this.opts.getfSMCallerExecutorDisruptor().shutdown();
        }
        if (this.opts.getNodeApplyDisruptor() != null) {
            this.opts.getNodeApplyDisruptor().shutdown();
        }
        if (this.opts.getReadOnlyServiceDisruptor() != null) {
            this.opts.getReadOnlyServiceDisruptor().shutdown();
        }
        if (this.opts.getLogManagerDisruptor() != null) {
            this.opts.getLogManagerDisruptor().shutdown();
        }
        if (this.opts.getCommonExecutor() != null) {
            ExecutorServiceHelper.shutdownAndAwaitTermination(this.opts.getCommonExecutor());
        }
        if (this.opts.getStripedExecutor() != null) {
            this.opts.getStripedExecutor().shutdownGracefully();
        }
        if (this.opts.getScheduler() != null) {
            this.opts.getScheduler().shutdown();
        }
        if (this.opts.getElectionTimer() != null) {
            this.opts.getElectionTimer().stop();
        }
        if (this.opts.getVoteTimer() != null) {
            this.opts.getVoteTimer().stop();
        }
        if (this.opts.getStepDownTimer() != null) {
            this.opts.getStepDownTimer().stop();
        }
        if (this.opts.getSnapshotTimer() != null) {
            this.opts.getSnapshotTimer().stop();
        }
        if (this.opts.getClientExecutor() != null) {
            ExecutorServiceHelper.shutdownAndAwaitTermination(this.opts.getClientExecutor());
        }
        ExecutorServiceHelper.shutdownAndAwaitTermination(this.requestExecutor);
        this.logStorageFactory.close();
    }

    @Override
    public ClusterService clusterService() {
        return this.service;
    }

    public Path getServerDataPath(ReplicationGroupId groupId) {
        ClusterNode clusterNode = this.service.topologyService().localMember();
        String dirName = groupId + "_" + clusterNode.address().toString().replace(':', '_');
        return this.dataPath.resolve(dirName);
    }

    @Override
    public boolean startRaftGroup(ReplicationGroupId groupId, RaftGroupListener lsnr, @Nullable List<Peer> initialConf, RaftGroupOptions groupOptions) {
        return this.startRaftGroup(groupId, RaftGroupEventsListener.noopLsnr, lsnr, initialConf, groupOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startRaftGroup(ReplicationGroupId replicaGrpId, RaftGroupEventsListener evLsnr, RaftGroupListener lsnr, @Nullable List<Peer> initialConf, RaftGroupOptions groupOptions) {
        String grpId = replicaGrpId.toString();
        if (this.groups.containsKey(replicaGrpId)) {
            return false;
        }
        Object object = this.groupMonitor(grpId);
        synchronized (object) {
            if (this.groups.containsKey(replicaGrpId)) {
                return false;
            }
            NodeOptions nodeOptions = this.opts.copy();
            Path serverDataPath = this.getServerDataPath(replicaGrpId);
            try {
                Files.createDirectories(serverDataPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IgniteInternalException((Throwable)e);
            }
            nodeOptions.setLogUri(grpId);
            nodeOptions.setRaftMetaUri(serverDataPath.resolve("meta").toString());
            nodeOptions.setSnapshotUri(serverDataPath.resolve("snapshot").toString());
            nodeOptions.setFsm(new DelegatingStateMachine(lsnr));
            nodeOptions.setRaftGrpEvtsLsnr(evLsnr);
            LogStorageFactory logStorageFactory = groupOptions.getLogStorageFactory() == null ? this.logStorageFactory : groupOptions.getLogStorageFactory();
            IgniteJraftServiceFactory serviceFactory = new IgniteJraftServiceFactory(logStorageFactory);
            if (groupOptions.snapshotStorageFactory() != null) {
                serviceFactory.setSnapshotStorageFactory(groupOptions.snapshotStorageFactory());
            }
            if (groupOptions.raftMetaStorageFactory() != null) {
                serviceFactory.setRaftMetaStorageFactory(groupOptions.raftMetaStorageFactory());
            }
            nodeOptions.setServiceFactory(serviceFactory);
            if (initialConf != null) {
                List<PeerId> mapped = initialConf.stream().map(PeerId::fromPeer).collect(Collectors.toList());
                nodeOptions.setInitialConf(new Configuration(mapped, null));
            }
            IgniteRpcClient client = new IgniteRpcClient(this.service);
            nodeOptions.setRpcClient(client);
            if (groupOptions.replicationGroupOptions() != null) {
                nodeOptions.setSafeTimeTracker(groupOptions.replicationGroupOptions().safeTime());
            }
            NetworkAddress addr = this.service.topologyService().localMember().address();
            PeerId peerId = new PeerId(addr.host(), addr.port(), 0, -1);
            RaftGroupService server = new RaftGroupService(grpId, peerId, nodeOptions, this.rpcServer, this.nodeManager);
            server.start();
            this.groups.put(replicaGrpId, server);
            return true;
        }
    }

    @Override
    public boolean stopRaftGroup(ReplicationGroupId grpId) {
        boolean stopped;
        RaftGroupService svc = (RaftGroupService)this.groups.remove(grpId);
        boolean bl = stopped = svc != null;
        if (stopped) {
            svc.shutdown();
        }
        return stopped;
    }

    @Override
    public Peer localPeer(ReplicationGroupId groupId) {
        RaftGroupService service = (RaftGroupService)this.groups.get(groupId);
        if (service == null) {
            return null;
        }
        PeerId peerId = service.getRaftNode().getNodeId().getPeerId();
        return new Peer(JRaftUtils.addressFromEndpoint(peerId.getEndpoint()), peerId.getPriority());
    }

    public RaftGroupService raftGroupService(ReplicationGroupId groupId) {
        return (RaftGroupService)this.groups.get(groupId);
    }

    @Override
    public Set<ReplicationGroupId> startedGroups() {
        return this.groups.keySet();
    }

    @TestOnly
    public void blockMessages(ReplicationGroupId groupId, BiPredicate<Object, String> predicate) {
        IgniteRpcClient client = (IgniteRpcClient)((RaftGroupService)this.groups.get(groupId)).getNodeOptions().getRpcClient();
        client.blockMessages(predicate);
    }

    @TestOnly
    public void stopBlockMessages(ReplicationGroupId groupId) {
        IgniteRpcClient client = (IgniteRpcClient)((RaftGroupService)this.groups.get(groupId)).getNodeOptions().getRpcClient();
        client.stopBlock();
    }

    private Object groupMonitor(String grpId) {
        return this.startGroupInProgressMonitors.get(Math.abs(grpId.hashCode() % SIMULTANEOUS_GROUP_START_PARALLELISM));
    }

    public static class DelegatingStateMachine
    extends StateMachineAdapter {
        private final RaftGroupListener listener;

        DelegatingStateMachine(RaftGroupListener listener) {
            this.listener = listener;
        }

        public RaftGroupListener getListener() {
            return this.listener;
        }

        @Override
        public void onApply(final org.apache.ignite.raft.jraft.Iterator iter) {
            try {
                this.listener.onWrite((Iterator)new Iterator<CommandClosure<WriteCommand>>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public CommandClosure<WriteCommand> next() {
                        final @Nullable CommandClosure done = (CommandClosure)iter.done();
                        ByteBuffer data = iter.getData();
                        final WriteCommand command = done == null ? (WriteCommand)JDKMarshaller.DEFAULT.unmarshall(data.array()) : (WriteCommand)done.command();
                        final long commandIndex = iter.getIndex();
                        return new CommandClosure<WriteCommand>(){

                            public long index() {
                                return commandIndex;
                            }

                            public WriteCommand command() {
                                return command;
                            }

                            public void result(Serializable res) {
                                if (done != null) {
                                    done.result(res);
                                }
                                iter.next();
                            }
                        };
                    }
                });
            }
            catch (Exception err) {
                Status st = err.getMessage() != null ? new Status(RaftError.ESTATEMACHINE, err.getMessage(), new Object[0]) : new Status(RaftError.ESTATEMACHINE, "Unknown state machine error.", new Object[0]);
                if (iter.done() != null) {
                    iter.done().run(st);
                }
                iter.setErrorAndRollback(1L, st);
            }
        }

        @Override
        public void onSnapshotSave(SnapshotWriter writer, Closure done) {
            try {
                this.listener.onSnapshotSave(Path.of(writer.getPath(), new String[0]), res -> {
                    if (res == null) {
                        File file = new File(writer.getPath());
                        File[] snapshotFiles = file.listFiles();
                        if (snapshotFiles != null) {
                            for (File file0 : snapshotFiles) {
                                if (!file0.isFile()) continue;
                                writer.addFile(file0.getName(), null);
                            }
                        }
                        done.run(Status.OK());
                    } else {
                        done.run(new Status(RaftError.EIO, "Fail to save snapshot to %s, reason %s", writer.getPath(), res.getMessage()));
                    }
                });
            }
            catch (Exception e) {
                done.run(new Status(RaftError.EIO, "Fail to save snapshot %s", e.getMessage()));
            }
        }

        @Override
        public boolean onSnapshotLoad(SnapshotReader reader) {
            return this.listener.onSnapshotLoad(Path.of(reader.getPath(), new String[0]));
        }

        @Override
        public void onShutdown() {
            this.listener.onShutdown();
        }
    }
}

