/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.ReadIndexRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.util.ByteString;

public class ReadIndexRequestImpl
implements RpcRequests.ReadIndexRequest {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3012;
    @IgniteToStringInclude
    private List<ByteString> entriesList;
    private byte[] entriesListByteArray;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String peerId;
    @IgniteToStringInclude
    private final String serverId;

    private ReadIndexRequestImpl(List<ByteString> entriesList, byte[] entriesListByteArray, String groupId, String peerId, String serverId) {
        this.entriesList = entriesList;
        this.entriesListByteArray = entriesListByteArray;
        this.groupId = groupId;
        this.peerId = peerId;
        this.serverId = serverId;
    }

    byte[] entriesListByteArray() {
        return this.entriesListByteArray;
    }

    @Override
    public List<ByteString> entriesList() {
        return this.entriesList;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    @Override
    public String serverId() {
        return this.serverId;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ReadIndexRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 3012;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadIndexRequestImpl otherMessage = (ReadIndexRequestImpl)other;
        return Objects.equals(this.entriesList, otherMessage.entriesList) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.peerId, otherMessage.peerId) && Objects.equals(this.serverId, otherMessage.serverId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.entriesList, this.groupId, this.peerId, this.serverId);
        return result;
    }

    public static ReadIndexRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject entriesListByteArraymo = marshaller.marshal(this.entriesList);
        usedDescriptors.addAll((IntCollection)entriesListByteArraymo.usedDescriptorIds());
        this.entriesListByteArray = entriesListByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.entriesList = (List)marshaller.unmarshal(this.entriesListByteArray, descriptorsObj);
        this.entriesListByteArray = null;
    }

    private static class Builder
    implements ReadIndexRequestBuilder {
        private List<ByteString> entriesList;
        private byte[] entriesListByteArray;
        private String groupId;
        private String peerId;
        private String serverId;

        private Builder() {
        }

        @Override
        public ReadIndexRequestBuilder entriesList(List<ByteString> entriesList) {
            this.entriesList = entriesList;
            return this;
        }

        @Override
        public ReadIndexRequestBuilder entriesListByteArray(byte[] entriesListByteArray) {
            this.entriesListByteArray = entriesListByteArray;
            return this;
        }

        @Override
        public ReadIndexRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadIndexRequestBuilder peerId(String peerId) {
            this.peerId = peerId;
            return this;
        }

        @Override
        public ReadIndexRequestBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Override
        public List<ByteString> entriesList() {
            return this.entriesList;
        }

        @Override
        public byte[] entriesListByteArray() {
            return this.entriesListByteArray;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public String serverId() {
            return this.serverId;
        }

        @Override
        public RpcRequests.ReadIndexRequest build() {
            return new ReadIndexRequestImpl(this.entriesList, this.entriesListByteArray, this.groupId, this.peerId, this.serverId);
        }
    }
}

