/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.StringConcatFactory;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite.raft.jraft.option.LogStorageOptions;
import org.apache.ignite.raft.jraft.storage.impl.LogStorageException;
import org.apache.ignite.raft.jraft.storage.impl.Logs;
import org.apache.ignite.raft.jraft.util.BytesUtil;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.Utils;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDbSpillout
implements Logs {
    private static final IgniteLogger LOG = Loggers.forClass(RocksDbSpillout.class);
    private static final VarHandle LONG_ARRAY_HANDLE;
    private final RocksDB db;
    private final ColumnFamilyHandle columnFamily;
    private final WriteOptions writeOptions;
    private final byte[] groupStartPrefix;
    private final byte[] groupEndPrefix;
    private final Slice groupStartBound;
    private final Slice groupEndBound;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock useLock = this.readWriteLock.readLock();
    private final Lock manageLock = this.readWriteLock.writeLock();
    private boolean stopped = false;
    private final Executor executor;
    private LogEntryEncoder logEntryEncoder;
    private LogEntryDecoder logEntryDecoder;
    private volatile long firstLogIndex = 1L;
    private volatile long lastLogIndex = 0L;

    public RocksDbSpillout(RocksDB db, ColumnFamilyHandle columnFamily, String groupId, Executor executor) {
        Requires.requireNonNull(db);
        Requires.requireNonNull(columnFamily);
        Requires.requireNonNull(executor);
        Requires.requireTrue(groupId.indexOf(0) == -1, "Raft group id " + groupId + " must not contain char(0)");
        Requires.requireTrue(groupId.indexOf(1) == -1, "Raft group id " + groupId + " must not contain char(1)");
        this.db = db;
        this.columnFamily = columnFamily;
        this.executor = executor;
        this.groupStartPrefix = (groupId + "\u0000").getBytes(StandardCharsets.UTF_8);
        this.groupEndPrefix = ((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)groupId))).getBytes(StandardCharsets.UTF_8);
        this.groupStartBound = new Slice(this.groupStartPrefix);
        this.groupEndBound = new Slice(this.groupEndPrefix);
        this.writeOptions = new WriteOptions();
        this.writeOptions.setSync(false);
    }

    @Override
    public boolean init(LogStorageOptions opts) {
        Requires.requireNonNull(opts.getConfigurationManager(), "Null conf manager");
        Requires.requireNonNull(opts.getLogEntryCodecFactory(), "Null log entry codec factory");
        this.manageLock.lock();
        try {
            this.logEntryDecoder = opts.getLogEntryCodecFactory().decoder();
            this.logEntryEncoder = opts.getLogEntryCodecFactory().encoder();
            Requires.requireNonNull(this.logEntryDecoder, "Null log entry decoder");
            Requires.requireNonNull(this.logEntryEncoder, "Null log entry encoder");
            this.doInit();
            boolean bl = true;
            return bl;
        }
        finally {
            this.manageLock.unlock();
        }
    }

    private void doInit() {
        this.firstLogIndex = 1L;
        this.lastLogIndex = 0L;
    }

    private void setFirstLogIndex(long index) {
        this.firstLogIndex = index;
    }

    @Override
    public void shutdown() {
        this.manageLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            this.deleteWholeGroupRange();
            this.closeResources();
        }
        catch (RocksDBException e) {
            throw new LogStorageException("Cannot remove group keys", e);
        }
        finally {
            this.manageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry getEntry(long index) {
        this.useLock.lock();
        try {
            if (index < this.firstLogIndex || index > this.lastLogIndex) {
                LogEntry logEntry = null;
                return logEntry;
            }
            byte[] keyBytes = this.createKey(index);
            byte[] bs = this.getValueFromRocksDb(keyBytes);
            if (bs != null) {
                LogEntry entry = this.logEntryDecoder.decode(bs);
                if (entry != null) {
                    LogEntry logEntry = entry;
                    return logEntry;
                }
                LOG.error("Bad log entry format for index={}, the log data is: {}.", new Object[]{index, BytesUtil.toHex(bs)});
                LogEntry logEntry = null;
                return logEntry;
            }
        }
        catch (RocksDBException e) {
            LOG.error("Fail to get log entry at index {}.", (Throwable)e, new Object[]{index});
        }
        finally {
            this.useLock.unlock();
        }
        return null;
    }

    protected byte[] getValueFromRocksDb(byte[] keyBytes) throws RocksDBException {
        return this.db.get(this.columnFamily, keyBytes);
    }

    @Override
    public void appendEntry(LogEntry entry) {
        this.useLock.lock();
        try {
            if (this.stopped) {
                LOG.warn("Storage stopped.", new Object[0]);
                return;
            }
            long logIndex = entry.getId().getIndex();
            byte[] valueBytes = this.logEntryEncoder.encode(entry);
            this.db.put(this.columnFamily, this.writeOptions, this.createKey(logIndex), valueBytes);
        }
        catch (RocksDBException e) {
            LOG.error("Fail to append entry.", (Throwable)e);
            throw new LogStorageException("Fail to append entry", e);
        }
        finally {
            this.useLock.unlock();
        }
    }

    @Override
    public void appendEntries(List<LogEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        this.executeBatch(batch -> {
            for (LogEntry entry : entries) {
                this.addDataBatch(entry, batch);
            }
        });
    }

    @Override
    public void truncateSuffix(long lastIndexKept) {
        this.useLock.lock();
        try {
            this.db.deleteRange(this.columnFamily, this.writeOptions, this.createKey(lastIndexKept + 1L), this.createKey(this.lastLogIndex + 1L));
        }
        catch (RocksDBException e) {
            LOG.error("Fail to truncateSuffix {}.", (Throwable)e, new Object[]{lastIndexKept});
            throw new LogStorageException("Fail to truncateSuffix " + this.lastLogIndex, e);
        }
        finally {
            this.useLock.unlock();
        }
    }

    @Override
    public void reset() {
        this.manageLock.lock();
        try {
            this.deleteWholeGroupRange();
        }
        catch (RocksDBException e) {
            LOG.error("Fail to reset next log index.", (Throwable)e);
            throw new LogStorageException("Fail to reset next log index.", e);
        }
        finally {
            this.manageLock.unlock();
        }
        this.doInit();
    }

    private void deleteWholeGroupRange() throws RocksDBException {
        this.db.deleteRange(this.columnFamily, this.groupStartPrefix, this.groupEndPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncatePrefix(long firstIndexKept) {
        this.useLock.lock();
        try {
            long startIndex = this.firstLogIndex;
            this.setFirstLogIndex(firstIndexKept);
            this.truncatePrefixInBackground(startIndex, firstIndexKept);
        }
        finally {
            this.useLock.unlock();
        }
    }

    private void executeBatch(WriteBatchTemplate template) {
        this.useLock.lock();
        try (WriteBatch batch = new WriteBatch();){
            if (this.stopped) {
                LOG.warn("Storage stopped.", new Object[0]);
                return;
            }
            template.execute(batch);
            this.db.write(this.writeOptions, batch);
        }
        catch (RocksDBException e) {
            LOG.error("Execute batch failed with rocksdb exception.", (Throwable)e);
            throw new LogStorageException("Execute batch failed with rocksdb exception.", e);
        }
        catch (IOException e) {
            LOG.error("Execute batch failed with io exception.", (Throwable)e);
            throw new LogStorageException("Execute batch failed with io exception.", e);
        }
        finally {
            this.useLock.unlock();
        }
    }

    private void addDataBatch(LogEntry entry, WriteBatch batch) throws RocksDBException {
        long logIndex = entry.getId().getIndex();
        byte[] content = this.logEntryEncoder.encode(entry);
        batch.put(this.columnFamily, this.createKey(logIndex), content);
    }

    private void truncatePrefixInBackground(long startIndex, long firstIndexKept) {
        Utils.runInThread(this.executor, () -> {
            this.useLock.lock();
            try {
                if (this.stopped) {
                    return;
                }
                byte[] startKey = this.createKey(startIndex);
                byte[] endKey = this.createKey(firstIndexKept);
                this.db.deleteRange(this.columnFamily, startKey, endKey);
            }
            catch (RocksDBException e) {
                LOG.error("Fail to truncatePrefix {}.", (Throwable)e, new Object[]{firstIndexKept});
            }
            finally {
                this.useLock.unlock();
            }
        });
    }

    private void closeResources() {
        this.writeOptions.close();
        this.groupEndBound.close();
        this.groupStartBound.close();
    }

    private byte[] createKey(long index) {
        byte[] ks = new byte[this.groupStartPrefix.length + 8];
        System.arraycopy(this.groupStartPrefix, 0, ks, 0, this.groupStartPrefix.length);
        LONG_ARRAY_HANDLE.set(ks, this.groupStartPrefix.length, index);
        return ks;
    }

    static {
        RocksDB.loadLibrary();
        LONG_ARRAY_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
    }

    private static interface WriteBatchTemplate {
        public void execute(WriteBatch var1) throws RocksDBException, IOException;
    }
}

