/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.evict.PageEvictionTracker;
import org.apache.ignite.internal.pagememory.evict.PageEvictionTrackerNoOp;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PartitionMeta;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.pagememory.util.PageLockListenerNoOp;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.pagememory.AbstractPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumnsFreeList;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.pagememory.mv.PersistentPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersionFreeList;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class PersistentPageMemoryTableStorage
extends AbstractPageMemoryTableStorage {
    private final PersistentPageMemoryStorageEngine engine;
    private final PersistentPageMemoryDataRegion dataRegion;

    public PersistentPageMemoryTableStorage(PersistentPageMemoryStorageEngine engine, TableConfiguration tableCfg, PersistentPageMemoryDataRegion dataRegion, TablesConfiguration tablesCfg) {
        super(tableCfg, tablesCfg);
        this.engine = engine;
        this.dataRegion = dataRegion;
    }

    public PersistentPageMemoryStorageEngine engine() {
        return this.engine;
    }

    public PersistentPageMemoryDataRegion dataRegion() {
        return this.dataRegion;
    }

    public boolean isVolatile() {
        return false;
    }

    @Override
    public void start() throws StorageException {
        super.start();
        TableView tableView = (TableView)this.tableCfg.value();
        try {
            this.dataRegion.filePageStoreManager().initialize(tableView.name(), tableView.tableId(), tableView.partitions());
            int deltaFileCount = this.dataRegion.filePageStoreManager().getStores(tableView.tableId()).stream().mapToInt(FilePageStore::deltaFileCount).sum();
            this.dataRegion.checkpointManager().addDeltaFileCountForCompaction(deltaFileCount);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error initializing file page stores for table: " + tableView.name(), (Throwable)e);
        }
    }

    public void destroy() throws StorageException {
        this.close(true);
    }

    @Override
    public PersistentPageMemoryMvPartitionStorage createMvPartitionStorage(int partitionId) {
        TableView tableView = (TableView)this.tableCfg.value();
        FilePageStore filePageStore = this.ensurePartitionFilePageStore(tableView, partitionId);
        CheckpointManager checkpointManager = this.dataRegion.checkpointManager();
        CheckpointTimeoutLock checkpointTimeoutLock = checkpointManager.checkpointTimeoutLock();
        checkpointTimeoutLock.checkpointReadLock();
        try {
            PersistentPageMemory pageMemory = this.dataRegion.pageMemory();
            int grpId = tableView.tableId();
            PartitionMeta meta = this.dataRegion.partitionMetaManager().readOrCreateMeta(this.lastCheckpointId(), new GroupPartitionId(grpId, partitionId), filePageStore);
            this.dataRegion.partitionMetaManager().addMeta(new GroupPartitionId(grpId, partitionId), meta);
            filePageStore.pages(meta.pageCount());
            filePageStore.setPageAllocationListener(pageIdx -> {
                assert (checkpointTimeoutLock.checkpointLockIsHeldByThread());
                meta.incrementPageCount(this.lastCheckpointId());
            });
            RowVersionFreeList rowVersionFreeList = this.createRowVersionFreeList(tableView, partitionId, pageMemory, meta);
            IndexColumnsFreeList indexColumnsFreeList = this.createIndexColumnsFreeList(tableView, partitionId, (ReuseList)rowVersionFreeList, pageMemory, meta);
            VersionChainTree versionChainTree = this.createVersionChainTree(tableView, partitionId, (ReuseList)rowVersionFreeList, pageMemory, meta);
            IndexMetaTree indexMetaTree = this.createIndexMetaTree(tableView, partitionId, (ReuseList)rowVersionFreeList, pageMemory, meta);
            PersistentPageMemoryMvPartitionStorage persistentPageMemoryMvPartitionStorage = new PersistentPageMemoryMvPartitionStorage(this, partitionId, meta, rowVersionFreeList, indexColumnsFreeList, versionChainTree, indexMetaTree, this.tablesConfiguration);
            return persistentPageMemoryMvPartitionStorage;
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(String.format("Error getting or creating partition [tableName=%s, partitionId=%s]", tableView.name(), partitionId), (Throwable)e);
        }
        finally {
            checkpointTimeoutLock.checkpointReadUnlock();
        }
    }

    private FilePageStore ensurePartitionFilePageStore(TableView tableView, int partId) throws StorageException {
        try {
            FilePageStore filePageStore = this.dataRegion.filePageStoreManager().getStore(tableView.tableId(), partId);
            filePageStore.ensure();
            return filePageStore;
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(String.format("Error initializing file page store [tableName=%s, partitionId=%s]", tableView.name(), partId), (Throwable)e);
        }
    }

    @Nullable
    public UUID lastCheckpointId() {
        CheckpointProgress lastCeckpointProgress = this.dataRegion.checkpointManager().lastCheckpointProgress();
        return lastCeckpointProgress == null ? null : lastCeckpointProgress.id();
    }

    private RowVersionFreeList createRowVersionFreeList(TableView tableView, int partId, PersistentPageMemory pageMemory, PartitionMeta meta) throws StorageException {
        try {
            boolean initNew = false;
            if (meta.rowVersionFreeListRootPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(tableView.tableId(), partId, (byte)2);
                meta.rowVersionFreeListRootPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new RowVersionFreeList(tableView.tableId(), partId, (PageMemory)this.dataRegion.pageMemory(), null, (PageLockListener)PageLockListenerNoOp.INSTANCE, meta.rowVersionFreeListRootPageId(), initNew, this.dataRegion.pageListCacheLimit(), (PageEvictionTracker)PageEvictionTrackerNoOp.INSTANCE, (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(String.format("Error creating RowVersionFreeList [tableName=%s, partitionId=%s]", tableView.name(), partId), (Throwable)e);
        }
    }

    private IndexColumnsFreeList createIndexColumnsFreeList(TableView tableView, int partitionId, ReuseList reuseList, PersistentPageMemory pageMemory, PartitionMeta meta) {
        try {
            boolean initNew = false;
            if (meta.indexColumnsFreeListRootPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(tableView.tableId(), partitionId, (byte)2);
                meta.indexColumnsFreeListRootPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new IndexColumnsFreeList(tableView.tableId(), partitionId, (PageMemory)pageMemory, reuseList, (PageLockListener)PageLockListenerNoOp.INSTANCE, meta.indexColumnsFreeListRootPageId(), initNew, new AtomicLong(), (PageEvictionTracker)PageEvictionTrackerNoOp.INSTANCE, (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(String.format("Error creating IndexColumnsFreeList [tableName=%s, partitionId=%s]", tableView.name(), partitionId), (Throwable)e);
        }
    }

    private VersionChainTree createVersionChainTree(TableView tableView, int partId, ReuseList reuseList, PersistentPageMemory pageMemory, PartitionMeta meta) throws StorageException {
        try {
            boolean initNew = false;
            if (meta.versionChainTreeRootPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(tableView.tableId(), partId, (byte)2);
                meta.versionChainTreeRootPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new VersionChainTree(tableView.tableId(), tableView.name(), partId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, new AtomicLong(), meta.versionChainTreeRootPageId(), reuseList, initNew);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(String.format("Error creating VersionChainTree [tableName=%s, partitionId=%s]", tableView.name(), partId), (Throwable)e);
        }
    }

    private IndexMetaTree createIndexMetaTree(TableView tableView, int partitionId, ReuseList reuseList, PersistentPageMemory pageMemory, PartitionMeta meta) {
        try {
            boolean initNew = false;
            if (meta.indexTreeMetaPageId() == 0L) {
                long rootPageId = pageMemory.allocatePage(tableView.tableId(), partitionId, (byte)2);
                meta.indexTreeMetaPageId(this.lastCheckpointId(), rootPageId);
                initNew = true;
            }
            return new IndexMetaTree(tableView.tableId(), tableView.name(), partitionId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, new AtomicLong(), meta.indexTreeMetaPageId(), reuseList, initNew);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(String.format("Error creating IndexMetaTree [tableName=%s, partitionId=%s]", tableView.name(), partitionId), (Throwable)e);
        }
    }
}

