/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.sql.NoRowSetExpectedException;
import org.apache.ignite.sql.ResultSet;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.jetbrains.annotations.Nullable;

public class ResultSetImpl
implements ResultSet {
    private final AsyncResultSet ars;
    private final IteratorImpl it;

    public ResultSetImpl(AsyncResultSet ars) {
        assert (ars != null);
        this.ars = ars;
        this.it = ars.hasRowSet() ? new IteratorImpl(ars) : null;
    }

    @Override
    @Nullable
    public ResultSetMetadata metadata() {
        return this.ars.metadata();
    }

    @Override
    public boolean hasRowSet() {
        return this.ars.hasRowSet();
    }

    @Override
    public long affectedRows() {
        return this.ars.affectedRows();
    }

    @Override
    public boolean wasApplied() {
        return this.ars.wasApplied();
    }

    @Override
    public void close() {
        this.ars.closeAsync().toCompletableFuture().join();
    }

    @Override
    public boolean hasNext() {
        if (this.it == null) {
            throw new NoRowSetExpectedException();
        }
        return this.it.hasNext();
    }

    @Override
    public SqlRow next() {
        if (this.it == null) {
            throw new NoRowSetExpectedException();
        }
        return this.it.next();
    }

    private static class IteratorImpl
    implements Iterator<SqlRow> {
        private AsyncResultSet curRes;
        private CompletionStage<? extends AsyncResultSet> nextPageStage;
        private Iterator<SqlRow> curPage;

        IteratorImpl(AsyncResultSet ars) {
            this.curRes = ars;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            if (this.curPage.hasNext()) {
                return true;
            }
            if (this.nextPageStage != null) {
                try {
                    this.curRes = this.nextPageStage.toCompletableFuture().join();
                }
                catch (CompletionException ex) {
                    throw (IgniteException)ExceptionUtils.unwrapCause((Throwable)ex);
                }
                this.advance();
                return this.curPage.hasNext();
            }
            return false;
        }

        private void advance() {
            this.curPage = this.curRes.currentPage().iterator();
            this.nextPageStage = this.curRes.hasMorePages() ? this.curRes.fetchNextPage() : null;
        }

        @Override
        public SqlRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.curPage.next();
        }
    }
}

