/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.util.Objects;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.tostring.S;

public class DecimalNativeType
extends NativeType {
    public static final int DEFAULT_PRECISION = 19;
    public static final int DEFAULT_SCALE = 3;
    private final int precision;
    private final int scale;

    DecimalNativeType(int precision, int scale) {
        super(NativeTypeSpec.DECIMAL);
        this.precision = precision;
        this.scale = scale;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DecimalNativeType type = (DecimalNativeType)o;
        return this.precision == type.precision && this.scale == type.scale;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.scale);
    }

    @Override
    public String toString() {
        return S.toString((String)DecimalNativeType.class.getSimpleName(), (String)"name", (Object)((Object)this.spec()), (String)"precision", (Object)this.precision, (String)"scale", (Object)this.scale);
    }
}

