/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.thread;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.worker.IgniteWorker;

public class IgniteThread
extends Thread {
    private static final AtomicLong THREAD_COUNTER = new AtomicLong();
    protected final String igniteInstanceName;

    public IgniteThread(IgniteWorker worker) {
        this(worker.igniteInstanceName(), worker.name(), worker);
    }

    public IgniteThread(String nodeName, String threadName) {
        this(nodeName, threadName, null);
    }

    public IgniteThread(String nodeName, String threadName, Runnable r) {
        super(r, IgniteThread.createName(THREAD_COUNTER.incrementAndGet(), threadName, nodeName));
        this.igniteInstanceName = nodeName;
    }

    public String getIgniteInstanceName() {
        return this.igniteInstanceName;
    }

    public static IgniteThread current() {
        Thread thread = Thread.currentThread();
        return thread.getClass() == IgniteThread.class || thread instanceof IgniteThread ? (IgniteThread)thread : null;
    }

    public static String threadPrefix(String nodeName, String threadName) {
        return "%" + nodeName + "%" + threadName + "-";
    }

    protected static String createName(long num, String threadName, String nodeName) {
        return IgniteThread.threadPrefix(nodeName, threadName) + num;
    }

    @Override
    public String toString() {
        return S.toString(IgniteThread.class, this, "name", (Object)this.getName());
    }
}

