/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.ignite.client.IgniteClientConnectionException;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.client.ClientChannelConfiguration;
import org.apache.ignite.internal.client.PayloadInputChannel;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.PayloadReader;
import org.apache.ignite.internal.client.PayloadWriter;
import org.apache.ignite.internal.client.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.ProtocolContext;
import org.apache.ignite.internal.client.io.ClientConnection;
import org.apache.ignite.internal.client.io.ClientConnectionMultiplexer;
import org.apache.ignite.internal.client.io.ClientConnectionStateHandler;
import org.apache.ignite.internal.client.io.ClientMessageHandler;
import org.apache.ignite.internal.client.proto.ClientMessageCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.ProtocolVersion;
import org.apache.ignite.internal.client.proto.ResponseFlags;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.jetbrains.annotations.Nullable;

class TcpClientChannel
implements ClientChannel,
ClientMessageHandler,
ClientConnectionStateHandler {
    private static final ProtocolVersion DEFAULT_VERSION = ProtocolVersion.LATEST_VER;
    private static final Collection<ProtocolVersion> supportedVers = Collections.singletonList(ProtocolVersion.V3_0_0);
    private static final long MIN_RECOMMENDED_HEARTBEAT_INTERVAL = 500L;
    private volatile ProtocolContext protocolCtx;
    private final ClientConnection sock;
    private final AtomicLong reqId = new AtomicLong(1L);
    private final Map<Long, ClientRequestFuture> pendingReqs = new ConcurrentHashMap<Long, ClientRequestFuture>();
    private final Collection<Consumer<ClientChannel>> assignmentChangeListeners = new CopyOnWriteArrayList<Consumer<ClientChannel>>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Executor asyncContinuationExecutor;
    private final long connectTimeout;
    private final Timer heartbeatTimer;
    private volatile long lastSendMillis;

    TcpClientChannel(ClientChannelConfiguration cfg, ClientConnectionMultiplexer connMgr) {
        TcpClientChannel.validateConfiguration(cfg);
        this.asyncContinuationExecutor = cfg.clientConfiguration().asyncContinuationExecutor() == null ? ForkJoinPool.commonPool() : cfg.clientConfiguration().asyncContinuationExecutor();
        this.connectTimeout = cfg.clientConfiguration().connectTimeout();
        this.sock = connMgr.open(cfg.getAddress(), this, this);
        this.handshake(DEFAULT_VERSION);
        this.heartbeatTimer = this.initHeartbeat(cfg.clientConfiguration().heartbeatInterval());
    }

    @Override
    public void close() {
        this.close(null);
    }

    private void close(Exception cause) {
        if (this.closed.compareAndSet(false, true)) {
            Timer timer = this.heartbeatTimer;
            if (timer != null) {
                timer.cancel();
            }
            this.sock.close();
            for (ClientRequestFuture pendingReq : this.pendingReqs.values()) {
                pendingReq.completeExceptionally((Throwable)((Object)new IgniteClientConnectionException(ErrorGroups.Client.CONNECTION_ERR, "Channel is closed", cause)));
            }
        }
    }

    @Override
    public void onMessage(ByteBuf buf) {
        try {
            this.processNextMessage(buf);
        }
        catch (Throwable t) {
            buf.release();
            throw t;
        }
    }

    @Override
    public void onDisconnected(@Nullable Exception e) {
        this.close(e);
    }

    @Override
    public <T> CompletableFuture<T> serviceAsync(int opCode, PayloadWriter payloadWriter, PayloadReader<T> payloadReader) {
        try {
            ClientRequestFuture fut = this.send(opCode, payloadWriter);
            return this.receiveAsync(fut, payloadReader);
        }
        catch (Throwable t) {
            CompletableFuture fut = new CompletableFuture();
            fut.completeExceptionally(t);
            return fut;
        }
    }

    private ClientRequestFuture send(int opCode, PayloadWriter payloadWriter) {
        long id = this.reqId.getAndIncrement();
        if (this.closed()) {
            throw new IgniteClientConnectionException(ErrorGroups.Client.CONNECTION_ERR, "Channel is closed");
        }
        ClientRequestFuture fut = new ClientRequestFuture();
        this.pendingReqs.put(id, fut);
        PayloadOutputChannel payloadCh = new PayloadOutputChannel(this, new ClientMessagePacker(this.sock.getBuffer()));
        try {
            ClientMessagePacker req = payloadCh.out();
            req.packInt(opCode);
            req.packLong(id);
            if (payloadWriter != null) {
                payloadWriter.accept(payloadCh);
            }
            this.write(req).addListener(f -> {
                if (!f.isSuccess()) {
                    fut.completeExceptionally((Throwable)((Object)new IgniteClientConnectionException(ErrorGroups.Client.CONNECTION_ERR, "Failed to send request", f.cause())));
                }
            });
            return fut;
        }
        catch (Throwable t) {
            payloadCh.close();
            this.pendingReqs.remove(id);
            throw IgniteException.wrap((Throwable)t);
        }
    }

    private <T> CompletableFuture<T> receiveAsync(ClientRequestFuture pendingReq, PayloadReader<T> payloadReader) {
        return pendingReq.thenApplyAsync(payload -> {
            if (payload == null) {
                return null;
            }
            if (payloadReader == null) {
                payload.close();
                return null;
            }
            PayloadInputChannel in = new PayloadInputChannel(this, (ClientMessageUnpacker)payload);
            try {
                Object t = payloadReader.apply(in);
                in.close();
                return t;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IgniteClientConnectionException(ErrorGroups.Client.PROTOCOL_ERR, "Failed to deserialize server response: " + e.getMessage(), e);
                }
            }
        }, this.asyncContinuationExecutor);
    }

    private void processNextMessage(ByteBuf buf) throws IgniteException {
        ClientMessageUnpacker unpacker = new ClientMessageUnpacker(buf);
        if (this.protocolCtx == null) {
            this.pendingReqs.remove(-1L).complete(unpacker);
            return;
        }
        int type = unpacker.unpackInt();
        if (type != 0) {
            throw new IgniteClientConnectionException(ErrorGroups.Client.PROTOCOL_ERR, "Unexpected message type: " + type);
        }
        Long resId = unpacker.unpackLong();
        ClientRequestFuture pendingReq = this.pendingReqs.remove(resId);
        if (pendingReq == null) {
            throw new IgniteClientConnectionException(ErrorGroups.Client.PROTOCOL_ERR, String.format("Unexpected response ID [%s]", resId));
        }
        int flags = unpacker.unpackInt();
        if (ResponseFlags.getPartitionAssignmentChangedFlag((int)flags)) {
            for (Consumer<ClientChannel> listener : this.assignmentChangeListeners) {
                listener.accept(this);
            }
        }
        if (unpacker.tryUnpackNil()) {
            pendingReq.complete(unpacker);
        } else {
            IgniteException err = this.readError(unpacker);
            unpacker.close();
            pendingReq.completeExceptionally((Throwable)err);
        }
    }

    private IgniteException readError(ClientMessageUnpacker unpacker) {
        UUID traceId = unpacker.unpackUuid();
        int code = unpacker.unpackInt();
        String errClassName = unpacker.unpackString();
        String errMsg = unpacker.tryUnpackNil() ? null : unpacker.unpackString();
        IgniteException causeWithStackTrace = unpacker.tryUnpackNil() ? null : new IgniteException(traceId, code, unpacker.unpackString());
        try {
            Class<?> errCls = Class.forName(errClassName);
            if (IgniteException.class.isAssignableFrom(errCls)) {
                Constructor<?> constructor = errCls.getDeclaredConstructor(UUID.class, Integer.TYPE, String.class, Throwable.class);
                return (IgniteException)constructor.newInstance(traceId, code, errMsg, causeWithStackTrace);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return new IgniteException(traceId, code, errClassName + ": " + errMsg, (Throwable)causeWithStackTrace);
    }

    @Override
    public boolean closed() {
        return this.closed.get();
    }

    @Override
    public ProtocolContext protocolContext() {
        return this.protocolCtx;
    }

    @Override
    public void addTopologyAssignmentChangeListener(Consumer<ClientChannel> listener) {
        this.assignmentChangeListeners.add(listener);
    }

    private static void validateConfiguration(ClientChannelConfiguration cfg) {
        String error = null;
        InetSocketAddress addr = cfg.getAddress();
        if (addr == null) {
            error = "At least one Ignite server node must be specified in the Ignite client configuration";
        } else if (addr.getPort() < 1024 || addr.getPort() > 49151) {
            error = String.format("Ignite client port %s is out of valid ports range 1024...49151", addr.getPort());
        }
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    private void handshake(ProtocolVersion ver) throws IgniteClientConnectionException {
        ClientRequestFuture fut = new ClientRequestFuture();
        this.pendingReqs.put(-1L, fut);
        try {
            this.handshakeReq(ver);
            ClientMessageUnpacker res = this.connectTimeout > 0L ? (ClientMessageUnpacker)fut.get(this.connectTimeout, TimeUnit.MILLISECONDS) : (ClientMessageUnpacker)fut.get();
            this.handshakeRes(res, ver);
        }
        catch (Throwable e) {
            throw IgniteException.wrap((Throwable)e);
        }
    }

    private void handshakeReq(ProtocolVersion proposedVer) {
        this.sock.send(Unpooled.wrappedBuffer((byte[])ClientMessageCommon.MAGIC_BYTES));
        ClientMessagePacker req = new ClientMessagePacker(this.sock.getBuffer());
        req.packInt((int)proposedVer.major());
        req.packInt((int)proposedVer.minor());
        req.packInt((int)proposedVer.patch());
        req.packInt(2);
        req.packBinaryHeader(0);
        req.packMapHeader(0);
        this.write(req).syncUninterruptibly();
    }

    private void handshakeRes(ClientMessageUnpacker unpacker, ProtocolVersion proposedVer) {
        try (ClientMessageUnpacker clientMessageUnpacker = unpacker;){
            ProtocolVersion srvVer = new ProtocolVersion(unpacker.unpackShort(), unpacker.unpackShort(), unpacker.unpackShort());
            if (!unpacker.tryUnpackNil()) {
                if (!proposedVer.equals((Object)srvVer) && supportedVers.contains(srvVer)) {
                    this.handshake(srvVer);
                    return;
                }
                throw this.readError(unpacker);
            }
            long serverIdleTimeout = unpacker.unpackLong();
            String clusterNodeId = unpacker.unpackString();
            String clusterNodeName = unpacker.unpackString();
            InetSocketAddress addr = this.sock.remoteAddress();
            ClusterNode clusterNode = new ClusterNode(clusterNodeId, clusterNodeName, new NetworkAddress(addr.getHostName(), addr.getPort()));
            int featuresLen = unpacker.unpackBinaryHeader();
            unpacker.skipValues(featuresLen);
            int extensionsLen = unpacker.unpackMapHeader();
            unpacker.skipValues(extensionsLen);
            this.protocolCtx = new ProtocolContext(srvVer, ProtocolBitmaskFeature.allFeaturesAsEnumSet(), serverIdleTimeout, clusterNode);
        }
    }

    private ChannelFuture write(ClientMessagePacker packer) throws IgniteClientConnectionException {
        this.lastSendMillis = System.currentTimeMillis();
        ByteBuf buf = packer.getBuffer();
        return this.sock.send(buf);
    }

    private Timer initHeartbeat(long configuredInterval) {
        long heartbeatInterval = this.getHeartbeatInterval(configuredInterval);
        Timer timer = new Timer("tcp-client-channel-heartbeats-" + this.hashCode());
        timer.schedule((TimerTask)new HeartbeatTask(heartbeatInterval), heartbeatInterval, heartbeatInterval);
        return timer;
    }

    private long getHeartbeatInterval(long configuredInterval) {
        long serverIdleTimeoutMs = this.protocolCtx.serverIdleTimeout();
        if (serverIdleTimeoutMs <= 0L) {
            return configuredInterval;
        }
        long recommendedHeartbeatInterval = serverIdleTimeoutMs / 3L;
        if (recommendedHeartbeatInterval < 500L) {
            recommendedHeartbeatInterval = 500L;
        }
        return Math.min(configuredInterval, recommendedHeartbeatInterval);
    }

    private class HeartbeatTask
    extends TimerTask {
        private final long interval;

        public HeartbeatTask(long interval) {
            this.interval = interval;
        }

        @Override
        public void run() {
            try {
                if (System.currentTimeMillis() - TcpClientChannel.this.lastSendMillis > this.interval) {
                    TcpClientChannel.this.serviceAsync(1, null, null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ClientRequestFuture
    extends CompletableFuture<ClientMessageUnpacker> {
        private ClientRequestFuture() {
        }
    }
}

