/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.compute;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.table.ClientRecordSerializer;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTables;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;

public class ClientCompute
implements IgniteCompute {
    private static final String DEFAULT_SCHEMA_NAME = "PUBLIC";
    private static final Object MISSING_TABLE_TOKEN = new Object();
    private final ReliableChannel ch;
    private final ClientTables tables;
    private final ConcurrentHashMap<String, ClientTable> tableCache = new ConcurrentHashMap();

    public ClientCompute(ReliableChannel ch, ClientTables tables) {
        this.ch = ch;
        this.tables = tables;
    }

    public <R> CompletableFuture<R> execute(Set<ClusterNode> nodes, Class<? extends ComputeJob<R>> jobClass, Object ... args) {
        return this.execute(nodes, jobClass.getName(), args);
    }

    public <R> CompletableFuture<R> execute(Set<ClusterNode> nodes, String jobClassName, Object ... args) {
        Objects.requireNonNull(nodes);
        Objects.requireNonNull(jobClassName);
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be empty.");
        }
        ClusterNode node = this.randomNode(nodes);
        return this.executeOnOneNode(node, jobClassName, args);
    }

    public <R> CompletableFuture<R> executeColocated(String tableName, Tuple key, Class<? extends ComputeJob<R>> jobClass, Object ... args) {
        return this.executeColocated(tableName, key, jobClass.getName(), args);
    }

    public <K, R> CompletableFuture<R> executeColocated(String tableName, K key, Mapper<K> keyMapper, Class<? extends ComputeJob<R>> jobClass, Object ... args) {
        return this.executeColocated(tableName, key, keyMapper, jobClass.getName(), args);
    }

    public <R> CompletableFuture<R> executeColocated(String tableName, Tuple key, String jobClassName, Object ... args) {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(key);
        Objects.requireNonNull(jobClassName);
        return ((CompletableFuture)((CompletableFuture)this.getTable(tableName).thenCompose(table -> this.executeColocatedTupleKey((ClientTable)table, key, jobClassName, args))).handle((res, err) -> this.handleMissingTable(tableName, (Object)res, (Throwable)err))).thenCompose(r -> r == MISSING_TABLE_TOKEN ? this.executeColocated(tableName, key, jobClassName, args) : CompletableFuture.completedFuture(r));
    }

    public <K, R> CompletableFuture<R> executeColocated(String tableName, K key, Mapper<K> keyMapper, String jobClassName, Object ... args) {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(key);
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(jobClassName);
        return ((CompletableFuture)((CompletableFuture)this.getTable(tableName).thenCompose(table -> this.executeColocatedObjectKey((ClientTable)table, key, keyMapper, jobClassName, args))).handle((res, err) -> this.handleMissingTable(tableName, (Object)res, (Throwable)err))).thenCompose(r -> r == MISSING_TABLE_TOKEN ? this.executeColocated(tableName, key, keyMapper, jobClassName, args) : CompletableFuture.completedFuture(r));
    }

    public <R> Map<ClusterNode, CompletableFuture<R>> broadcast(Set<ClusterNode> nodes, Class<? extends ComputeJob<R>> jobClass, Object ... args) {
        return this.broadcast(nodes, jobClass.getName(), args);
    }

    public <R> Map<ClusterNode, CompletableFuture<R>> broadcast(Set<ClusterNode> nodes, String jobClassName, Object ... args) {
        Objects.requireNonNull(nodes);
        Objects.requireNonNull(jobClassName);
        HashMap<ClusterNode, CompletableFuture<R>> map = new HashMap<ClusterNode, CompletableFuture<R>>(nodes.size());
        for (ClusterNode node : nodes) {
            if (map.put(node, this.executeOnOneNode(node, jobClassName, args)) == null) continue;
            throw new IllegalStateException("Node can't be specified more than once: " + node);
        }
        return map;
    }

    private <R> CompletableFuture<R> executeOnOneNode(ClusterNode node, String jobClassName, Object[] args) {
        return this.ch.serviceAsync(47, w -> {
            if (w.clientChannel().protocolContext().clusterNode().name().equals(node.name())) {
                w.out().packNil();
            } else {
                w.out().packString(node.name());
            }
            w.out().packString(jobClassName);
            w.out().packObjectArrayAsBinaryTuple(args);
        }, r -> r.in().unpackObjectFromBinaryTuple(), node.name(), null);
    }

    private ClusterNode randomNode(Set<ClusterNode> nodes) {
        if (nodes.size() == 1) {
            return nodes.iterator().next();
        }
        int nodesToSkip = ThreadLocalRandom.current().nextInt(nodes.size());
        Iterator<ClusterNode> iterator = nodes.iterator();
        for (int i = 0; i < nodesToSkip; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    private <K, R> CompletableFuture<R> executeColocatedObjectKey(ClientTable t, K key, Mapper<K> keyMapper, String jobClassName, Object[] args) {
        return t.doSchemaOutOpAsync(49, (schema, outputChannel) -> {
            ClientMessagePacker w = outputChannel.out();
            w.packUuid(t.tableId());
            w.packInt(schema.version());
            ClientRecordSerializer.writeRecRaw(key, keyMapper, schema, w, TuplePart.KEY);
            w.packString(jobClassName);
            w.packObjectArrayAsBinaryTuple(args);
        }, r -> r.unpackObjectFromBinaryTuple());
    }

    private <R> CompletableFuture<R> executeColocatedTupleKey(ClientTable t, Tuple key, String jobClassName, Object[] args) {
        return t.doSchemaOutOpAsync(49, (schema, outputChannel) -> {
            ClientMessagePacker w = outputChannel.out();
            w.packUuid(t.tableId());
            w.packInt(schema.version());
            ClientTupleSerializer.writeTupleRaw(key, schema, outputChannel, true);
            w.packString(jobClassName);
            w.packObjectArrayAsBinaryTuple(args);
        }, r -> r.unpackObjectFromBinaryTuple());
    }

    private CompletableFuture<ClientTable> getTable(String tableName) {
        ClientTable cached = this.tableCache.get(tableName);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        return this.tables.tableAsync(tableName).thenApply(t -> {
            if (t == null) {
                throw new TableNotFoundException(DEFAULT_SCHEMA_NAME, tableName);
            }
            ClientTable clientTable = (ClientTable)t;
            this.tableCache.put(t.name(), clientTable);
            return clientTable;
        });
    }

    private <R> R handleMissingTable(String tableName, R res, Throwable err) {
        IgniteException clientEx;
        if (err instanceof CompletionException) {
            err = err.getCause();
        }
        if (err instanceof IgniteException && (clientEx = (IgniteException)err).code() == ErrorGroups.Client.TABLE_ID_NOT_FOUND_ERR) {
            this.tableCache.remove(tableName);
            return (R)MISSING_TABLE_TOKEN;
        }
        if (err != null) {
            throw new CompletionException(err);
        }
        return res;
    }
}

