/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.ignite.raft.jraft.option;

/**
 * Apply task in blocking or non-blocking mode.
 *
 */
public enum ApplyTaskMode {
    // It is strongly not recommended to use blocking mode because it is forbidden to use blocking code in Ignite worker threads.
    // This mode is not deleted mostly because of the desire to not differ with the original JRaft.
    Blocking,
    NonBlocking
}
