/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.handlers;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.partition.replicator.ReplicationRaftCommandApplicator;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaSafeTimeSyncRequest;
import org.apache.ignite.internal.util.CompletableFutures;

public class ReplicaSafeTimeSyncRequestHandler {
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final ReplicationRaftCommandApplicator commandApplicator;
    private final ClockService clockService;

    public ReplicaSafeTimeSyncRequestHandler(ClockService clockService, ReplicationRaftCommandApplicator commandApplicator) {
        this.clockService = clockService;
        this.commandApplicator = commandApplicator;
    }

    public CompletableFuture<?> handle(ReplicaSafeTimeSyncRequest request, boolean isPrimary) {
        if (!isPrimary) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.commandApplicator.applyCommandWithExceptionHandling((Command)REPLICA_MESSAGES_FACTORY.safeTimeSyncCommand().initiatorTime(this.clockService.now()).build());
    }
}

