/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.bulkload;

import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCacheWriter;
import org.apache.ignite.lang.IgniteBiTuple;

public class BulkLoadStreamerWriter
extends BulkLoadCacheWriter {
    private static final long serialVersionUID = 0L;
    private final IgniteDataStreamer<Object, Object> streamer;
    private long updateCnt;

    public BulkLoadStreamerWriter(IgniteDataStreamer<Object, Object> streamer) {
        this.streamer = streamer;
        this.updateCnt = 0L;
    }

    @Override
    public void apply(IgniteBiTuple<?, ?> entry) {
        this.streamer.addData(entry.getKey(), entry.getValue());
        ++this.updateCnt;
    }

    @Override
    public void close() {
        this.streamer.close();
    }

    @Override
    public long updateCnt() {
        return this.updateCnt;
    }
}

