/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.filename;

import java.io.File;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderResolver;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFoldersResolver;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PdsConsistentIdProcessor
extends GridProcessorAdapter
implements PdsFoldersResolver {
    private final IgniteLogger log;
    private final GridKernalContext ctx;
    private PdsFolderSettings<GridCacheDatabaseSharedManager.NodeFileLockHolder> settings;

    public PdsConsistentIdProcessor(GridKernalContext ctx) {
        super(ctx);
        this.log = ctx.log(PdsFoldersResolver.class);
        this.ctx = ctx;
    }

    @Override
    public PdsFolderSettings<GridCacheDatabaseSharedManager.NodeFileLockHolder> resolveFolders() throws IgniteCheckedException {
        if (this.settings == null) {
            PdsFolderResolver<GridCacheDatabaseSharedManager.NodeFileLockHolder> resolver = new PdsFolderResolver<GridCacheDatabaseSharedManager.NodeFileLockHolder>(this.ctx.config(), this.log, this.ctx.discovery().consistentId(), this::tryLock);
            this.settings = resolver.resolve();
            if (this.settings == null) {
                this.settings = resolver.generateNew();
            }
            if (!this.settings.isCompatible()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Consistent ID used for local node is [" + this.settings.consistentId() + "] according to persistence data storage folders");
                }
                this.ctx.discovery().consistentId(this.settings.consistentId());
            }
        }
        return this.settings;
    }

    private GridCacheDatabaseSharedManager.NodeFileLockHolder tryLock(File dbStoreDirWithSubdirectory) {
        if (!dbStoreDirWithSubdirectory.exists()) {
            return null;
        }
        String path = dbStoreDirWithSubdirectory.getAbsolutePath();
        GridCacheDatabaseSharedManager.NodeFileLockHolder fileLockHolder = new GridCacheDatabaseSharedManager.NodeFileLockHolder(path, this.ctx, this.log);
        try {
            fileLockHolder.tryLock(1000L);
            return fileLockHolder;
        }
        catch (IgniteCheckedException e) {
            U.closeQuiet(fileLockHolder);
            if (this.log.isInfoEnabled()) {
                this.log.info("Unable to acquire lock to file [" + path + "], reason: " + e.getMessage());
            }
            return null;
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        GridCacheDatabaseSharedManager.NodeFileLockHolder fileLockHolder;
        if (this.settings != null && (fileLockHolder = this.settings.getLockedFileLockHolder()) != null) {
            fileLockHolder.close();
        }
        super.stop(cancel);
    }
}

