/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.JumpInstruction;
import com.facebook.presto.bytecode.instruction.LabelNode;
import java.util.List;
import java.util.Objects;

class ComparisonBytecodeExpression
extends BytecodeExpression {
    private final String infixSymbol;
    private final OpCode comparisonInstruction;
    private final OpCode noMatchJumpInstruction;
    private final BytecodeExpression left;
    private final BytecodeExpression right;

    static BytecodeExpression lessThan(BytecodeExpression left, BytecodeExpression right) {
        OpCode noMatchJumpInstruction;
        OpCode comparisonInstruction;
        ComparisonBytecodeExpression.checkArgumentTypes(left, right);
        Class<?> type = left.getType().getPrimitiveType();
        if (type == Integer.TYPE) {
            comparisonInstruction = null;
            noMatchJumpInstruction = OpCode.IF_ICMPGE;
        } else if (type == Long.TYPE) {
            comparisonInstruction = OpCode.LCMP;
            noMatchJumpInstruction = OpCode.IFGE;
        } else if (type == Float.TYPE) {
            comparisonInstruction = OpCode.FCMPG;
            noMatchJumpInstruction = OpCode.IFGE;
        } else if (type == Double.TYPE) {
            comparisonInstruction = OpCode.DCMPG;
            noMatchJumpInstruction = OpCode.IFGE;
        } else {
            throw new IllegalArgumentException("Less than does not support " + type);
        }
        return new ComparisonBytecodeExpression("<", comparisonInstruction, noMatchJumpInstruction, left, right);
    }

    static BytecodeExpression greaterThan(BytecodeExpression left, BytecodeExpression right) {
        OpCode noMatchJumpInstruction;
        OpCode comparisonInstruction;
        ComparisonBytecodeExpression.checkArgumentTypes(left, right);
        Class<?> type = left.getType().getPrimitiveType();
        if (type == Integer.TYPE) {
            comparisonInstruction = null;
            noMatchJumpInstruction = OpCode.IF_ICMPLE;
        } else if (type == Long.TYPE) {
            comparisonInstruction = OpCode.LCMP;
            noMatchJumpInstruction = OpCode.IFLE;
        } else if (type == Float.TYPE) {
            comparisonInstruction = OpCode.FCMPL;
            noMatchJumpInstruction = OpCode.IFLE;
        } else if (type == Double.TYPE) {
            comparisonInstruction = OpCode.DCMPL;
            noMatchJumpInstruction = OpCode.IFLE;
        } else {
            throw new IllegalArgumentException("Greater than does not support " + type);
        }
        return new ComparisonBytecodeExpression(">", comparisonInstruction, noMatchJumpInstruction, left, right);
    }

    static BytecodeExpression lessThanOrEqual(BytecodeExpression left, BytecodeExpression right) {
        OpCode noMatchJumpInstruction;
        OpCode comparisonInstruction;
        ComparisonBytecodeExpression.checkArgumentTypes(left, right);
        Class<?> type = left.getType().getPrimitiveType();
        if (type == Integer.TYPE) {
            comparisonInstruction = null;
            noMatchJumpInstruction = OpCode.IF_ICMPGT;
        } else if (type == Long.TYPE) {
            comparisonInstruction = OpCode.LCMP;
            noMatchJumpInstruction = OpCode.IFGT;
        } else if (type == Float.TYPE) {
            comparisonInstruction = OpCode.FCMPG;
            noMatchJumpInstruction = OpCode.IFGT;
        } else if (type == Double.TYPE) {
            comparisonInstruction = OpCode.DCMPG;
            noMatchJumpInstruction = OpCode.IFGT;
        } else {
            throw new IllegalArgumentException("Less than or equal does not support " + type);
        }
        return new ComparisonBytecodeExpression("<=", comparisonInstruction, noMatchJumpInstruction, left, right);
    }

    static BytecodeExpression greaterThanOrEqual(BytecodeExpression left, BytecodeExpression right) {
        OpCode noMatchJumpInstruction;
        OpCode comparisonInstruction;
        ComparisonBytecodeExpression.checkArgumentTypes(left, right);
        Class<?> type = left.getType().getPrimitiveType();
        if (type == Integer.TYPE) {
            comparisonInstruction = null;
            noMatchJumpInstruction = OpCode.IF_ICMPLT;
        } else if (type == Long.TYPE) {
            comparisonInstruction = OpCode.LCMP;
            noMatchJumpInstruction = OpCode.IFLT;
        } else if (type == Float.TYPE) {
            comparisonInstruction = OpCode.FCMPL;
            noMatchJumpInstruction = OpCode.IFLT;
        } else if (type == Double.TYPE) {
            comparisonInstruction = OpCode.DCMPL;
            noMatchJumpInstruction = OpCode.IFLT;
        } else {
            throw new IllegalArgumentException("Greater than or equal does not support " + type);
        }
        return new ComparisonBytecodeExpression(">=", comparisonInstruction, noMatchJumpInstruction, left, right);
    }

    static BytecodeExpression equal(BytecodeExpression left, BytecodeExpression right) {
        OpCode noMatchJumpInstruction;
        OpCode comparisonInstruction;
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        BytecodeUtils.checkArgument(left.getType().equals(right.getType()), "left and right must be the same type", new Object[0]);
        Class<?> type = left.getType().getPrimitiveType();
        if (type == Integer.TYPE) {
            comparisonInstruction = null;
            noMatchJumpInstruction = OpCode.IF_ICMPNE;
        } else if (type == Long.TYPE) {
            comparisonInstruction = OpCode.LCMP;
            noMatchJumpInstruction = OpCode.IFNE;
        } else if (type == Float.TYPE) {
            comparisonInstruction = OpCode.FCMPL;
            noMatchJumpInstruction = OpCode.IFNE;
        } else if (type == Double.TYPE) {
            comparisonInstruction = OpCode.DCMPL;
            noMatchJumpInstruction = OpCode.IFNE;
        } else if (type == null) {
            comparisonInstruction = null;
            noMatchJumpInstruction = OpCode.IF_ACMPNE;
        } else {
            throw new IllegalArgumentException("Equal does not support " + type);
        }
        return new ComparisonBytecodeExpression("==", comparisonInstruction, noMatchJumpInstruction, left, right);
    }

    static BytecodeExpression notEqual(BytecodeExpression left, BytecodeExpression right) {
        OpCode noMatchJumpInstruction;
        OpCode comparisonInstruction;
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        BytecodeUtils.checkArgument(left.getType().equals(right.getType()), "left and right must be the same type", new Object[0]);
        Class<?> type = left.getType().getPrimitiveType();
        if (type == Integer.TYPE) {
            comparisonInstruction = null;
            noMatchJumpInstruction = OpCode.IF_ICMPEQ;
        } else if (type == Long.TYPE) {
            comparisonInstruction = OpCode.LCMP;
            noMatchJumpInstruction = OpCode.IFEQ;
        } else if (type == Float.TYPE) {
            comparisonInstruction = OpCode.FCMPL;
            noMatchJumpInstruction = OpCode.IFEQ;
        } else if (type == Double.TYPE) {
            comparisonInstruction = OpCode.DCMPL;
            noMatchJumpInstruction = OpCode.IFEQ;
        } else if (type == null) {
            comparisonInstruction = null;
            noMatchJumpInstruction = OpCode.IF_ACMPEQ;
        } else {
            throw new IllegalArgumentException("Not equal than does not support " + type);
        }
        return new ComparisonBytecodeExpression("!=", comparisonInstruction, noMatchJumpInstruction, left, right);
    }

    private static void checkArgumentTypes(BytecodeExpression left, BytecodeExpression right) {
        Class<?> rightType;
        Class<?> leftType = ComparisonBytecodeExpression.getPrimitiveType(left, "left");
        BytecodeUtils.checkArgument(leftType == (rightType = ComparisonBytecodeExpression.getPrimitiveType(right, "right")), "left and right must be the same type", new Object[0]);
    }

    private static Class<?> getPrimitiveType(BytecodeExpression expression, String name) {
        Objects.requireNonNull(expression, name + " is null");
        Class<?> leftType = expression.getType().getPrimitiveType();
        BytecodeUtils.checkArgument(leftType != null, name + " is not a primitive", new Object[0]);
        BytecodeUtils.checkArgument(leftType != Void.TYPE, name + " is void", new Object[0]);
        return leftType;
    }

    private ComparisonBytecodeExpression(String infixSymbol, OpCode comparisonInstruction, OpCode noMatchJumpInstruction, BytecodeExpression left, BytecodeExpression right) {
        super(ParameterizedType.type(Boolean.TYPE));
        this.infixSymbol = infixSymbol;
        this.comparisonInstruction = comparisonInstruction;
        this.noMatchJumpInstruction = noMatchJumpInstruction;
        this.left = left;
        this.right = right;
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        BytecodeBlock block = new BytecodeBlock().append(this.left).append(this.right);
        if (this.comparisonInstruction != null) {
            block.append(this.comparisonInstruction);
        }
        LabelNode noMatch = new LabelNode("no_match");
        LabelNode end = new LabelNode("end");
        return block.append(new JumpInstruction(this.noMatchJumpInstruction, noMatch)).push(true).gotoLabel(end).append(noMatch).push(false).append(end);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of(this.left, this.right);
    }

    @Override
    protected String formatOneLine() {
        return "(" + this.left + " " + this.infixSymbol + " " + this.right + ")";
    }
}

