/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util.subscription;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;

public class IterableToPublisherAdapter<T>
implements Flow.Publisher<T> {
    private final CompletableFuture<? extends Iterable<T>> iterableFuture;
    private final Executor executor;
    private final int batchSize;

    public IterableToPublisherAdapter(CompletableFuture<? extends Iterable<T>> iterableFuture, Executor executor, int batchSize) {
        this.iterableFuture = iterableFuture;
        this.executor = executor;
        this.batchSize = batchSize;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        CompletionStage itFuture = this.iterableFuture.thenApply(Iterable::iterator);
        SubscriptionImpl<? super T> subscription = new SubscriptionImpl<T>(itFuture, subscriber, this.executor, this.batchSize);
        subscriber.onSubscribe(subscription);
    }

    private static class SubscriptionImpl<T>
    implements Flow.Subscription {
        private static final VarHandle CANCELLED_HANDLE;
        private static final VarHandle REQUESTED_HANDLE;
        private static final VarHandle WIP_HANDLE;
        private final CompletableFuture<Iterator<T>> itFuture;
        private final Flow.Subscriber<? super T> subscriber;
        private final Executor executor;
        private final int batchSize;
        private boolean cancelled = false;
        private long requested = 0L;
        private boolean wip = false;

        SubscriptionImpl(CompletableFuture<Iterator<T>> itFuture, Flow.Subscriber<? super T> subscriber, Executor executor, int batchSize) {
            this.itFuture = itFuture;
            this.subscriber = subscriber;
            this.executor = executor;
            this.batchSize = batchSize;
        }

        @Override
        public void request(long n) {
            long newValue;
            long oldValue;
            if (n <= 0L) {
                this.notifyError(new IllegalArgumentException("N should be positive:" + n));
                return;
            }
            if (CANCELLED_HANDLE.getAcquire(this)) {
                return;
            }
            do {
                if ((newValue = (oldValue = REQUESTED_HANDLE.getAcquire(this)) + n) >= 0L) continue;
                newValue = Long.MAX_VALUE;
            } while (!REQUESTED_HANDLE.compareAndSet(this, oldValue, newValue));
            this.itFuture.whenComplete((ignored, ex) -> {
                if (ex != null) {
                    this.notifyError((Throwable)ex);
                    return;
                }
                this.executor.execute(this::drain);
            });
        }

        @Override
        public void cancel() {
            CANCELLED_HANDLE.setRelease(this, true);
        }

        private void drain() {
            if (!WIP_HANDLE.compareAndSet(this, false, true)) {
                return;
            }
            if (CANCELLED_HANDLE.getAcquire(this)) {
                return;
            }
            long amount = this.amountToDrain();
            assert (this.itFuture.isDone());
            Iterator<T> it = this.itFuture.join();
            try {
                while (amount-- > 0L && it.hasNext()) {
                    this.subscriber.onNext(it.next());
                }
            }
            catch (Throwable th) {
                this.notifyError(th);
            }
            if (!it.hasNext()) {
                if (CANCELLED_HANDLE.compareAndSet(this, false, true)) {
                    this.subscriber.onComplete();
                }
                return;
            }
            WIP_HANDLE.setRelease(this, false);
            if (REQUESTED_HANDLE.getAcquire(this) > 0L) {
                this.executor.execute(this::drain);
            }
        }

        private long amountToDrain() {
            long newRequested;
            long oldRequested;
            while (!REQUESTED_HANDLE.compareAndSet(this, oldRequested, newRequested = (oldRequested = REQUESTED_HANDLE.getAcquire(this)) <= (long)this.batchSize ? 0L : oldRequested - (long)this.batchSize)) {
            }
            return oldRequested - newRequested;
        }

        private void notifyError(Throwable th) {
            if (!CANCELLED_HANDLE.compareAndSet(this, false, true)) {
                return;
            }
            this.subscriber.onError(th);
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                CANCELLED_HANDLE = lookup.findVarHandle(SubscriptionImpl.class, "cancelled", Boolean.TYPE);
                REQUESTED_HANDLE = lookup.findVarHandle(SubscriptionImpl.class, "requested", Long.TYPE);
                WIP_HANDLE = lookup.findVarHandle(SubscriptionImpl.class, "wip", Boolean.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

