/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.polaris.service.auth.OAuthTokenErrorResponse;

public class TokenRequestValidator {
    static final Logger LOGGER = Logger.getLogger(TokenRequestValidator.class.getName());
    public static final String TOKEN_EXCHANGE = "urn:ietf:params:oauth:grant-type:token-exchange";
    public static final String CLIENT_CREDENTIALS = "client_credentials";
    public static final Set<String> ALLOWED_GRANT_TYPES = Set.of("client_credentials", "urn:ietf:params:oauth:grant-type:token-exchange");

    public Optional<OAuthTokenErrorResponse.Error> validateForClientCredentialsFlow(String clientId, String clientSecret, String grantType, String scope) {
        String[] scopes;
        if (clientId == null || clientId.isEmpty() || clientSecret == null || clientSecret.isEmpty()) {
            LOGGER.info("Missing Client ID or Client Secret in Request Body");
            return Optional.of(OAuthTokenErrorResponse.Error.invalid_client);
        }
        if (grantType == null || grantType.isEmpty() || !ALLOWED_GRANT_TYPES.contains(grantType)) {
            LOGGER.info("Invalid grant type: " + grantType);
            return Optional.of(OAuthTokenErrorResponse.Error.invalid_grant);
        }
        if (scope == null || scope.isEmpty()) {
            LOGGER.info("Missing scope in Request Body");
            return Optional.of(OAuthTokenErrorResponse.Error.invalid_scope);
        }
        for (String s : scopes = scope.split(" ")) {
            if (!s.startsWith("PRINCIPAL_ROLE:")) {
                LOGGER.info("Invalid scope provided. scopes=" + s + "scopes=" + scope);
                return Optional.of(OAuthTokenErrorResponse.Error.invalid_scope);
            }
            if (!s.replaceFirst("PRINCIPAL_ROLE:", "").isEmpty()) continue;
            LOGGER.info("Invalid scope provided. scopes=" + s + "scopes=" + scope);
            return Optional.of(OAuthTokenErrorResponse.Error.invalid_scope);
        }
        return Optional.empty();
    }
}

