/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;

public class MicrometerRecorder
implements MetricsRecorder {
    private static final Tag RESULT_VALUE_RETURNED = Tag.of((String)"result", (String)"valueReturned");
    private static final Tag RESULT_EXCEPTION_THROWN = Tag.of((String)"result", (String)"exceptionThrown");
    private static final Tag FALLBACK_APPLIED = Tag.of((String)"fallback", (String)"applied");
    private static final Tag FALLBACK_NOT_APPLIED = Tag.of((String)"fallback", (String)"notApplied");
    private static final Tag FALLBACK_NOT_DEFINED = Tag.of((String)"fallback", (String)"notDefined");
    private static final Tag RETRIED_TRUE = Tag.of((String)"retried", (String)"true");
    private static final Tag RETRIED_FALSE = Tag.of((String)"retried", (String)"false");
    private static final Tag RETRY_RESULT_VALUE_RETURNED = Tag.of((String)"retryResult", (String)"valueReturned");
    private static final Tag RETRY_RESULT_EXCEPTION_NOT_RETRYABLE = Tag.of((String)"retryResult", (String)"exceptionNotRetryable");
    private static final Tag RETRY_RESULT_MAX_RETRIES_REACHED = Tag.of((String)"retryResult", (String)"maxRetriesReached");
    private static final Tag RETRY_RESULT_MAX_DURATION_REACHED = Tag.of((String)"retryResult", (String)"maxDurationReached");
    private static final Tag TIMED_OUT_TRUE = Tag.of((String)"timedOut", (String)"true");
    private static final Tag TIMED_OUT_FALSE = Tag.of((String)"timedOut", (String)"false");
    private static final Tag CIRCUIT_BREAKER_RESULT_SUCCESS = Tag.of((String)"circuitBreakerResult", (String)"success");
    private static final Tag CIRCUIT_BREAKER_RESULT_FAILURE = Tag.of((String)"circuitBreakerResult", (String)"failure");
    private static final Tag CIRCUIT_BREAKER_RESULT_CB_OPEN = Tag.of((String)"circuitBreakerResult", (String)"circuitBreakerOpen");
    private static final Tag CIRCUIT_BREAKER_STATE_CLOSED = Tag.of((String)"state", (String)"closed");
    private static final Tag CIRCUIT_BREAKER_STATE_OPEN = Tag.of((String)"state", (String)"open");
    private static final Tag CIRCUIT_BREAKER_STATE_HALF_OPEN = Tag.of((String)"state", (String)"halfOpen");
    private static final Tag BULKHEAD_RESULT_ACCEPTED = Tag.of((String)"bulkheadResult", (String)"accepted");
    private static final Tag BULKHEAD_RESULT_REJECTED = Tag.of((String)"bulkheadResult", (String)"rejected");
    private static final Tag RATE_LIMIT_RESULT_PERMITTED = Tag.of((String)"rateLimitResult", (String)"permitted");
    private static final Tag RATE_LIMIT_RESULT_REJECTED = Tag.of((String)"rateLimitResult", (String)"rejected");
    private final MeterRegistry registry;
    private final Tag methodTag;
    private final Iterable<Tag> methodTagSingleton;

    public MicrometerRecorder(MeterRegistry registry, MeteredOperation operation) {
        this.registry = registry;
        this.methodTag = Tag.of((String)"method", (String)operation.name());
        this.methodTagSingleton = Collections.singleton(this.methodTag);
        this.registerMetrics(operation);
    }

    private void registerMetrics(MeteredOperation operation) {
        if (operation.hasFallback()) {
            this.registry.counter("ft.invocations.total", Arrays.asList(this.methodTag, RESULT_VALUE_RETURNED, FALLBACK_NOT_APPLIED));
            this.registry.counter("ft.invocations.total", Arrays.asList(this.methodTag, RESULT_VALUE_RETURNED, FALLBACK_APPLIED)).count();
            this.registry.counter("ft.invocations.total", Arrays.asList(this.methodTag, RESULT_EXCEPTION_THROWN, FALLBACK_NOT_APPLIED));
            this.registry.counter("ft.invocations.total", Arrays.asList(this.methodTag, RESULT_EXCEPTION_THROWN, FALLBACK_APPLIED));
        } else {
            this.registry.counter("ft.invocations.total", Arrays.asList(this.methodTag, RESULT_VALUE_RETURNED, FALLBACK_NOT_DEFINED));
            this.registry.counter("ft.invocations.total", Arrays.asList(this.methodTag, RESULT_EXCEPTION_THROWN, FALLBACK_NOT_DEFINED));
        }
        if (operation.hasRetry()) {
            this.registry.counter("ft.retry.retries.total", this.methodTagSingleton);
            this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, RETRIED_FALSE, RETRY_RESULT_VALUE_RETURNED));
            this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, RETRIED_FALSE, RETRY_RESULT_EXCEPTION_NOT_RETRYABLE));
            this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, RETRIED_FALSE, RETRY_RESULT_MAX_RETRIES_REACHED));
            this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, RETRIED_FALSE, RETRY_RESULT_MAX_DURATION_REACHED));
            this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, RETRIED_TRUE, RETRY_RESULT_VALUE_RETURNED));
            this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, RETRIED_TRUE, RETRY_RESULT_EXCEPTION_NOT_RETRYABLE));
            this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, RETRIED_TRUE, RETRY_RESULT_MAX_RETRIES_REACHED));
            this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, RETRIED_TRUE, RETRY_RESULT_MAX_DURATION_REACHED));
        }
        if (operation.hasTimeout()) {
            this.registry.counter("ft.timeout.calls.total", Arrays.asList(this.methodTag, TIMED_OUT_TRUE));
            this.registry.counter("ft.timeout.calls.total", Arrays.asList(this.methodTag, TIMED_OUT_FALSE));
            this.registry.timer("ft.timeout.executionDuration", this.methodTagSingleton);
        }
        if (operation.hasCircuitBreaker()) {
            this.registry.counter("ft.circuitbreaker.calls.total", Arrays.asList(this.methodTag, CIRCUIT_BREAKER_RESULT_SUCCESS));
            this.registry.counter("ft.circuitbreaker.calls.total", Arrays.asList(this.methodTag, CIRCUIT_BREAKER_RESULT_FAILURE));
            this.registry.counter("ft.circuitbreaker.calls.total", Arrays.asList(this.methodTag, CIRCUIT_BREAKER_RESULT_CB_OPEN));
            this.registry.counter("ft.circuitbreaker.opened.total", this.methodTagSingleton);
        }
        if (operation.hasBulkhead()) {
            this.registry.counter("ft.bulkhead.calls.total", Arrays.asList(this.methodTag, BULKHEAD_RESULT_ACCEPTED));
            this.registry.counter("ft.bulkhead.calls.total", Arrays.asList(this.methodTag, BULKHEAD_RESULT_REJECTED));
            this.registry.timer("ft.bulkhead.runningDuration", this.methodTagSingleton);
            if (operation.mayBeAsynchronous()) {
                this.registry.timer("ft.bulkhead.waitingDuration", this.methodTagSingleton);
            }
        }
        if (operation.hasRateLimit()) {
            this.registry.counter("ft.ratelimit.calls.total", Arrays.asList(this.methodTag, BULKHEAD_RESULT_ACCEPTED));
            this.registry.counter("ft.ratelimit.calls.total", Arrays.asList(this.methodTag, BULKHEAD_RESULT_REJECTED));
        }
    }

    private void registerGauge(LongSupplier supplier, String name, Tag ... tags) {
        this.registry.gauge(name, Arrays.asList(tags), (Object)supplier, ignored -> supplier.getAsLong());
    }

    private void registerGauge(BooleanSupplier supplier, String name, Tag ... tags) {
        this.registry.gauge(name, Arrays.asList(tags), (Object)supplier, ignored -> supplier.getAsBoolean() ? 1.0 : 0.0);
    }

    private void registerTimeGauge(LongSupplier supplier, String name, Tag ... tags) {
        this.registry.more().timeGauge(name, Arrays.asList(tags), (Object)supplier, TimeUnit.NANOSECONDS, ignored -> supplier.getAsLong());
    }

    @Override
    public void executionFinished(boolean succeeded, boolean fallbackDefined, boolean fallbackApplied) {
        Tag resultTag;
        Tag tag = resultTag = succeeded ? RESULT_VALUE_RETURNED : RESULT_EXCEPTION_THROWN;
        Tag fallbackTag = fallbackDefined ? (fallbackApplied ? FALLBACK_APPLIED : FALLBACK_NOT_APPLIED) : FALLBACK_NOT_DEFINED;
        this.registry.counter("ft.invocations.total", Arrays.asList(this.methodTag, resultTag, fallbackTag)).increment();
    }

    @Override
    public void retryAttempted() {
        this.registry.counter("ft.retry.retries.total", this.methodTagSingleton).increment();
    }

    @Override
    public void retryValueReturned(boolean retried) {
        this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_VALUE_RETURNED)).increment();
    }

    @Override
    public void retryExceptionNotRetryable(boolean retried) {
        this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_EXCEPTION_NOT_RETRYABLE)).increment();
    }

    @Override
    public void retryMaxRetriesReached(boolean retried) {
        this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_MAX_RETRIES_REACHED)).increment();
    }

    @Override
    public void retryMaxDurationReached(boolean retried) {
        this.registry.counter("ft.retry.calls.total", Arrays.asList(this.methodTag, retried ? RETRIED_TRUE : RETRIED_FALSE, RETRY_RESULT_MAX_DURATION_REACHED)).increment();
    }

    @Override
    public void timeoutFinished(boolean timedOut, long time) {
        this.registry.counter("ft.timeout.calls.total", Arrays.asList(this.methodTag, timedOut ? TIMED_OUT_TRUE : TIMED_OUT_FALSE)).increment();
        this.registry.timer("ft.timeout.executionDuration", this.methodTagSingleton).record(time, TimeUnit.NANOSECONDS);
    }

    @Override
    public void circuitBreakerFinished(CircuitBreakerEvents.Result result) {
        Tag circuitBreakerResultTag = null;
        switch (result) {
            case SUCCESS: {
                circuitBreakerResultTag = CIRCUIT_BREAKER_RESULT_SUCCESS;
                break;
            }
            case FAILURE: {
                circuitBreakerResultTag = CIRCUIT_BREAKER_RESULT_FAILURE;
                break;
            }
            case PREVENTED: {
                circuitBreakerResultTag = CIRCUIT_BREAKER_RESULT_CB_OPEN;
            }
        }
        this.registry.counter("ft.circuitbreaker.calls.total", Arrays.asList(this.methodTag, circuitBreakerResultTag)).increment();
    }

    @Override
    public void circuitBreakerMovedToOpen() {
        this.registry.counter("ft.circuitbreaker.opened.total", this.methodTagSingleton).increment();
    }

    @Override
    public void registerCircuitBreakerIsClosed(BooleanSupplier supplier) {
        this.registerGauge(supplier, "ft.circuitbreaker.state.current", this.methodTag, CIRCUIT_BREAKER_STATE_CLOSED);
    }

    @Override
    public void registerCircuitBreakerIsOpen(BooleanSupplier supplier) {
        this.registerGauge(supplier, "ft.circuitbreaker.state.current", this.methodTag, CIRCUIT_BREAKER_STATE_OPEN);
    }

    @Override
    public void registerCircuitBreakerIsHalfOpen(BooleanSupplier supplier) {
        this.registerGauge(supplier, "ft.circuitbreaker.state.current", this.methodTag, CIRCUIT_BREAKER_STATE_HALF_OPEN);
    }

    @Override
    public void registerCircuitBreakerTimeSpentInClosed(LongSupplier supplier) {
        this.registerTimeGauge(supplier, "ft.circuitbreaker.state.total", this.methodTag, CIRCUIT_BREAKER_STATE_CLOSED);
    }

    @Override
    public void registerCircuitBreakerTimeSpentInOpen(LongSupplier supplier) {
        this.registerTimeGauge(supplier, "ft.circuitbreaker.state.total", this.methodTag, CIRCUIT_BREAKER_STATE_OPEN);
    }

    @Override
    public void registerCircuitBreakerTimeSpentInHalfOpen(LongSupplier supplier) {
        this.registerTimeGauge(supplier, "ft.circuitbreaker.state.total", this.methodTag, CIRCUIT_BREAKER_STATE_HALF_OPEN);
    }

    @Override
    public void bulkheadDecisionMade(boolean accepted) {
        Tag bulkheadResultTag = accepted ? BULKHEAD_RESULT_ACCEPTED : BULKHEAD_RESULT_REJECTED;
        this.registry.counter("ft.bulkhead.calls.total", Arrays.asList(this.methodTag, bulkheadResultTag)).increment();
    }

    @Override
    public void registerBulkheadExecutionsRunning(LongSupplier supplier) {
        this.registerGauge(supplier, "ft.bulkhead.executionsRunning", this.methodTag);
    }

    @Override
    public void registerBulkheadExecutionsWaiting(LongSupplier supplier) {
        this.registerGauge(supplier, "ft.bulkhead.executionsWaiting", this.methodTag);
    }

    @Override
    public void updateBulkheadRunningDuration(long time) {
        this.registry.timer("ft.bulkhead.runningDuration", this.methodTagSingleton).record(time, TimeUnit.NANOSECONDS);
    }

    @Override
    public void updateBulkheadWaitingDuration(long time) {
        this.registry.timer("ft.bulkhead.waitingDuration", this.methodTagSingleton).record(time, TimeUnit.NANOSECONDS);
    }

    @Override
    public void rateLimitDecisionMade(boolean permitted) {
        Tag rateLimitResultTag = permitted ? RATE_LIMIT_RESULT_PERMITTED : RATE_LIMIT_RESULT_REJECTED;
        this.registry.counter("ft.ratelimit.calls.total", Arrays.asList(this.methodTag, rateLimitResultTag)).increment();
    }
}

