/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.StorageConfigInfo;

@ApiModel(description="aws storage configuration info")
public class AwsStorageConfigInfo
extends StorageConfigInfo {
    @NotNull
    private final String roleArn;
    private final String externalId;
    private final String userArn;
    private final String region;

    @ApiModelProperty(example="arn:aws:iam::123456789001:principal/abc1-b-self1234", required=true, value="the aws role arn that grants privileges on the S3 buckets")
    @JsonProperty(value="roleArn", required=true)
    public String getRoleArn() {
        return this.roleArn;
    }

    @ApiModelProperty(value="an optional external id used to establish a trust relationship with AWS in the trust policy")
    @JsonProperty(value="externalId")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(example="arn:aws:iam::123456789001:user/abc1-b-self1234", value="the aws user arn used to assume the aws role")
    @JsonProperty(value="userArn")
    public String getUserArn() {
        return this.userArn;
    }

    @ApiModelProperty(example="us-east-2", value="the aws region where data is stored")
    @JsonProperty(value="region")
    public String getRegion() {
        return this.region;
    }

    @JsonCreator
    public AwsStorageConfigInfo(@JsonProperty(value="roleArn", required=true) String roleArn, @JsonProperty(value="externalId") String externalId, @JsonProperty(value="userArn") String userArn, @JsonProperty(value="region") String region, @JsonProperty(value="storageType", required=true) StorageConfigInfo.StorageTypeEnum storageType, @JsonProperty(value="allowedLocations") List<String> allowedLocations) {
        super(storageType, allowedLocations);
        this.roleArn = roleArn;
        this.externalId = externalId;
        this.userArn = userArn;
        this.region = region;
    }

    public AwsStorageConfigInfo(String roleArn, StorageConfigInfo.StorageTypeEnum storageType) {
        super(storageType);
        this.roleArn = roleArn;
        this.externalId = null;
        this.userArn = null;
        this.region = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roleArn, StorageConfigInfo.StorageTypeEnum storageType) {
        return new Builder(roleArn, storageType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsStorageConfigInfo awsStorageConfigInfo = (AwsStorageConfigInfo)o;
        return super.equals(o) && Objects.equals(this.roleArn, awsStorageConfigInfo.roleArn) && Objects.equals(this.externalId, awsStorageConfigInfo.externalId) && Objects.equals(this.userArn, awsStorageConfigInfo.userArn) && Objects.equals(this.region, awsStorageConfigInfo.region);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.roleArn, super.hashCode(), this.externalId, super.hashCode(), this.userArn, super.hashCode(), this.region);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AwsStorageConfigInfo {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    roleArn: ").append(this.toIndentedString(this.roleArn)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    userArn: ").append(this.toIndentedString(this.userArn)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String roleArn;
        private String externalId;
        private String userArn;
        private String region;
        private StorageConfigInfo.StorageTypeEnum storageType;
        private List<String> allowedLocations;

        private Builder() {
        }

        private Builder(String roleArn, StorageConfigInfo.StorageTypeEnum storageType) {
            this.roleArn = roleArn;
            this.storageType = storageType;
        }

        public Builder setRoleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public Builder setExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder setUserArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setStorageType(StorageConfigInfo.StorageTypeEnum storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder setAllowedLocations(List<String> allowedLocations) {
            this.allowedLocations = allowedLocations;
            return this;
        }

        public AwsStorageConfigInfo build() {
            AwsStorageConfigInfo inst = new AwsStorageConfigInfo(this.roleArn, this.externalId, this.userArn, this.region, this.storageType, this.allowedLocations);
            return inst;
        }
    }
}

