/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.policy.content.maintenance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.apache.polaris.core.policy.content.PolicyContentUtil;
import org.apache.polaris.core.policy.content.maintenance.BaseMaintenancePolicyContent;
import org.apache.polaris.core.policy.validator.InvalidPolicyException;

public class OrphanFileRemovalPolicyContent
extends BaseMaintenancePolicyContent {
    private static final String DEFAULT_POLICY_SCHEMA_VERSION = "2025-02-03";
    private static final Set<String> POLICY_SCHEMA_VERSIONS = Set.of("2025-02-03");
    @JsonProperty(value="max_orphan_file_age_in_days")
    private int maxOrphanFileAgeInDays;
    private List<String> locations;

    @JsonCreator
    public OrphanFileRemovalPolicyContent(@JsonProperty(value="enable", required=true) boolean enable) {
        super(enable);
    }

    public int getMaxOrphanFileAgeInDays() {
        return this.maxOrphanFileAgeInDays;
    }

    public void setMaxOrphanFileAgeInDays(int maxOrphanFileAgeInDays) {
        this.maxOrphanFileAgeInDays = maxOrphanFileAgeInDays;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public static OrphanFileRemovalPolicyContent fromString(String content) {
        OrphanFileRemovalPolicyContent policy;
        if (Strings.isNullOrEmpty((String)content)) {
            throw new InvalidPolicyException("Policy is empty");
        }
        try {
            policy = (OrphanFileRemovalPolicyContent)PolicyContentUtil.MAPPER.readValue(content, OrphanFileRemovalPolicyContent.class);
        }
        catch (Exception e) {
            throw new InvalidPolicyException(e);
        }
        OrphanFileRemovalPolicyContent.validateVersion(content, policy, DEFAULT_POLICY_SCHEMA_VERSION, POLICY_SCHEMA_VERSIONS);
        int maxAge = policy.getMaxOrphanFileAgeInDays();
        if (maxAge < 0) {
            throw new InvalidPolicyException("Invalid max_orphan_file_age_in_days: " + maxAge + ". It must be greater than or equal to 0");
        }
        return policy;
    }
}

