/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.admintool;

import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.polaris.admintool.BaseCommand;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import picocli.CommandLine;

@CommandLine.Command(name="bootstrap", mixinStandardHelpOptions=true, description={"Bootstraps realms and root principal credentials."})
public class BootstrapCommand
extends BaseCommand {
    @CommandLine.ArgGroup(multiplicity="1")
    InputOptions inputOptions;

    @Override
    public Integer call() {
        try {
            List<String> realms;
            RootCredentialsSet rootCredentialsSet;
            if (this.inputOptions.fileOptions != null) {
                rootCredentialsSet = RootCredentialsSet.fromUrl((URL)this.inputOptions.fileOptions.file.toUri().toURL());
                realms = rootCredentialsSet.credentials().keySet().stream().toList();
            } else {
                realms = this.inputOptions.stdinOptions.realms;
                RootCredentialsSet rootCredentialsSet2 = rootCredentialsSet = this.inputOptions.stdinOptions.credentials == null || this.inputOptions.stdinOptions.credentials.isEmpty() ? RootCredentialsSet.EMPTY : RootCredentialsSet.fromList(this.inputOptions.stdinOptions.credentials);
                if ((this.inputOptions.stdinOptions.credentials == null || this.inputOptions.stdinOptions.credentials.isEmpty()) && !this.inputOptions.stdinOptions.printCredentials) {
                    this.spec.commandLine().getErr().println("Specify either `--credentials` or `--print-credentials` to ensure the root user is accessible after bootstrapping.");
                    return 3;
                }
            }
            Map results = this.metaStoreManagerFactory.bootstrapRealms(realms, rootCredentialsSet);
            boolean success = true;
            for (Map.Entry result : results.entrySet()) {
                String realm;
                if (((PrincipalSecretsResult)result.getValue()).isSuccess()) {
                    realm = (String)result.getKey();
                    this.spec.commandLine().getOut().printf("Realm '%s' successfully bootstrapped.%n", realm);
                    if (this.inputOptions.stdinOptions == null || !this.inputOptions.stdinOptions.printCredentials) continue;
                    String msg = String.format("realm: %1s root principal credentials: %2s:%3s", result.getKey(), ((PrincipalSecretsResult)result.getValue()).getPrincipalSecrets().getPrincipalClientId(), ((PrincipalSecretsResult)result.getValue()).getPrincipalSecrets().getMainSecret());
                    this.spec.commandLine().getOut().println(msg);
                    continue;
                }
                realm = (String)result.getKey();
                this.spec.commandLine().getErr().printf("Bootstrapping '%s' failed: %s%n", realm, ((PrincipalSecretsResult)result.getValue()).getReturnStatus().toString());
                success = false;
            }
            if (success) {
                this.spec.commandLine().getOut().println("Bootstrap completed successfully.");
                return 0;
            }
            this.spec.commandLine().getErr().println("Bootstrap encountered errors during operation.");
            return 3;
        }
        catch (Exception e) {
            e.printStackTrace(this.spec.commandLine().getErr());
            this.spec.commandLine().getErr().println("Bootstrap encountered errors during operation.");
            return 3;
        }
    }

    static class InputOptions {
        @CommandLine.ArgGroup(multiplicity="1", exclusive=false)
        StandardInputOptions stdinOptions;
        @CommandLine.ArgGroup(multiplicity="1")
        FileInputOptions fileOptions;

        InputOptions() {
        }

        static class FileInputOptions {
            @CommandLine.Option(names={"-f", "--credentials-file"}, paramLabel="<file>", description={"A file containing root principal credentials to bootstrap."})
            Path file;

            FileInputOptions() {
            }
        }

        static class StandardInputOptions {
            @CommandLine.Option(names={"-r", "--realm"}, paramLabel="<realm>", required=true, description={"The name of a realm to bootstrap."})
            List<String> realms;
            @CommandLine.Option(names={"-c", "--credential"}, paramLabel="<realm,clientId,clientSecret>", description={"Root principal credentials to bootstrap. Must be of the form 'realm,clientId,clientSecret'."})
            List<String> credentials;
            @CommandLine.Option(names={"-p", "--print-credentials"}, description={"Print root credentials to stdout"})
            boolean printCredentials;

            StandardInputOptions() {
            }
        }
    }
}

