/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.api;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.catalog.api.IcebergRestConfigurationApiService;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/catalog/v1/config")
public class IcebergRestConfigurationApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergRestConfigurationApi.class);
    private final IcebergRestConfigurationApiService service;

    @Inject
    public IcebergRestConfigurationApi(IcebergRestConfigurationApiService service) {
        this.service = service;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.ConfigurationApi.getConfig")
    @Timeout
    public Response getConfig(@QueryParam(value="warehouse") String warehouse, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking ConfigurationApi with params").addKeyValue("operation", (Object)"getConfig").addKeyValue("warehouse", (Object)warehouse).log();
        Response ret = this.service.getConfig(warehouse, realmContext, securityContext);
        LOGGER.debug("Completed execution of getConfig API with status code {}", (Object)ret.getStatus());
        return ret;
    }
}

