/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.BearerAuthenticationMechanism;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.jboss.logging.Logger;

@ApplicationScoped
public class OidcAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final Logger LOG = Logger.getLogger(OidcAuthenticationMechanism.class);
    private static final HttpCredentialTransport OIDC_WEB_APP_TRANSPORT = new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION_CODE, "code");
    private final BearerAuthenticationMechanism bearerAuth;
    private final CodeAuthenticationMechanism codeAuth;
    private final DefaultTenantConfigResolver resolver;

    public OidcAuthenticationMechanism(DefaultTenantConfigResolver resolver, BlockingSecurityExecutor blockingExecutor) {
        this.bearerAuth = new BearerAuthenticationMechanism();
        this.resolver = resolver;
        this.codeAuth = new CodeAuthenticationMechanism(blockingExecutor);
        this.bearerAuth.init((HttpAuthenticationMechanism)this, resolver);
        this.codeAuth.init((HttpAuthenticationMechanism)this, resolver);
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        return this.resolve(context).chain((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return this.resolve(context).chain((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Uni<OidcTenantConfig> resolve(RoutingContext context) {
        OidcTenantConfig resolvedConfig = (OidcTenantConfig)context.get(OidcTenantConfig.class.getName());
        if (resolvedConfig != null) {
            return Uni.createFrom().item((Object)resolvedConfig);
        }
        OidcAuthenticationMechanism.setTenantIdAttribute(context);
        return this.resolver.resolveConfig(context).map((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isWebApp(RoutingContext context, OidcTenantConfig oidcConfig) {
        OidcTenantConfig.ApplicationType applicationType = oidcConfig.applicationType().orElse(OidcTenantConfig.ApplicationType.SERVICE);
        if (OidcTenantConfig.ApplicationType.HYBRID == applicationType) {
            return context.request().getHeader("Authorization") == null;
        }
        return OidcTenantConfig.ApplicationType.WEB_APP == applicationType;
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        return this.resolve(context).onItem().transform((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void setTenantIdAttribute(RoutingContext context) {
        if (context.get("tenant-id") == null) {
            for (String cookieName : context.cookieMap().keySet()) {
                if (OidcUtils.isSessionCookie((String)cookieName)) {
                    OidcAuthenticationMechanism.setTenantIdAttribute(context, "q_session", cookieName, true);
                    break;
                }
                if (!cookieName.startsWith("q_auth")) continue;
                OidcAuthenticationMechanism.setTenantIdAttribute(context, "q_auth", cookieName, false);
                break;
            }
        }
    }

    private static void setTenantIdAttribute(RoutingContext context, String cookiePrefix, String cookieName, boolean sessionCookie) {
        String tenantId = OidcUtils.getTenantIdFromCookie((String)cookiePrefix, (String)cookieName, (boolean)sessionCookie);
        context.put("tenant-id", (Object)tenantId);
        context.put(sessionCookie ? "tenant-id-set-by-session-cookie" : "tenant-id-set-by-state-cookie", (Object)tenantId);
        LOG.debugf("%s cookie set a '%s' tenant id on the %s request path", (Object)cookieName, (Object)tenantId, (Object)context.request().path());
    }

    public int getPriority() {
        return 1001;
    }

    public OidcAuthenticationMechanism() {
    }
}

