/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class MethodAttributeAccessor
extends AttributeAccessor {
    protected String setMethodName = "";
    protected String getMethodName;
    protected transient Method setMethod;
    protected transient Method getMethod;

    @Override
    public Class<?> getAttributeClass() {
        if (this.getGetMethod() == null) {
            return null;
        }
        return this.getGetMethodReturnType();
    }

    @Override
    public Object getAttributeValueFromObject(Object anObject) throws DescriptorException {
        return this.getAttributeValueFromObject(anObject, null);
    }

    protected Object getAttributeValueFromObject(Object anObject, Object[] parameters) throws DescriptorException {
        return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> this.getMethod.invoke(anObject, parameters), ex -> {
            if (ex instanceof IllegalArgumentException) {
                return DescriptorException.illegalArgumentWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), ex);
            }
            if (ex instanceof IllegalAccessException) {
                return DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), ex);
            }
            if (ex instanceof InvocationTargetException) {
                return DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), ex);
            }
            if (ex instanceof NullPointerException) {
                return DescriptorException.nullPointerWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), ex);
            }
            return new RuntimeException(String.format("Invocation of %s getter method failed", this.getMethod.getName()), ex);
        });
    }

    public Method getGetMethod() {
        return this.getMethod;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public Class<?> getGetMethodReturnType() throws DescriptorException {
        if (null == this.getGetMethod() && null != this.getGetMethodName() && this.getGetMethodName().indexOf("_persistence_") > -1) {
            AbstractSessionLog.getLog().log(1, "no_weaved_vh_method_found_verify_weaving_and_module_order", this.getGetMethodName(), null, (Object)this);
            throw DescriptorException.nullPointerWhileGettingValueThruMethodAccessorCausedByWeavingNotOccurringBecauseOfModuleOrder(this.getGetMethodName(), "", null);
        }
        return PrivilegedAccessHelper.callDoPrivileged(() -> PrivilegedAccessHelper.getMethodReturnType(this.getGetMethod()));
    }

    protected Method getSetMethod() {
        return this.setMethod;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public Class<?> getSetMethodParameterType() {
        return this.getSetMethodParameterType(0);
    }

    protected Class<?> getSetMethodParameterType(int index) {
        return PrivilegedAccessHelper.callDoPrivileged(() -> PrivilegedAccessHelper.getMethodParameterTypes(this.getSetMethod())[index]);
    }

    protected Class<?>[] getSetMethodParameterTypes() {
        return new Class[]{this.getGetMethodReturnType()};
    }

    @Override
    public void initializeAttributes(Class<?> theJavaClass) throws DescriptorException {
        this.initializeAttributes(theJavaClass, null);
    }

    protected void initializeAttributes(Class<?> theJavaClass, Class<?>[] getParameterTypes) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setGetMethod(Helper.getDeclaredMethod(theJavaClass, this.getGetMethodName(), getParameterTypes));
            if (!this.isWriteOnly()) {
                this.setSetMethod(Helper.getDeclaredMethod(theJavaClass, this.getSetMethodName(), this.getSetMethodParameterTypes()));
            }
        }
        catch (NoSuchMethodException ex) {
            DescriptorException descriptorException = DescriptorException.noSuchMethodWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), theJavaClass.getName());
            descriptorException.setInternalException(ex);
            throw descriptorException;
        }
        catch (SecurityException exception) {
            DescriptorException descriptorException = DescriptorException.securityWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), theJavaClass.getName());
            descriptorException.setInternalException(exception);
            throw descriptorException;
        }
    }

    @Override
    public boolean isInitialized() {
        return !(this.getMethod == null && !this.isReadOnly() || this.setMethod == null && !this.isWriteOnly());
    }

    @Override
    public boolean isMethodAttributeAccessor() {
        return true;
    }

    @Override
    public void setAttributeValueInObject(Object domainObject, Object attributeValue) throws DescriptorException {
        this.setAttributeValueInObject(domainObject, attributeValue, new Object[]{attributeValue});
    }

    protected void setAttributeValueInObject(Object domainObject, Object attributeValue, Object[] parameters) throws DescriptorException {
        try {
            PrivilegedAccessHelper.callDoPrivilegedWithException(() -> this.setMethod.invoke(domainObject, parameters));
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
        }
        catch (IllegalArgumentException exception) {
            try {
                if (attributeValue instanceof String) {
                    Object[] newParameters = new Object[]{ConversionManager.getDefaultManager().convertObject(attributeValue, this.getAttributeClass())};
                    PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), domainObject, newParameters));
                    return;
                }
            }
            catch (Exception newParameters) {
                // empty catch block
            }
            throw DescriptorException.illegalArgumentWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
        }
        catch (NullPointerException exception) {
            Class<?> fieldClass = this.getSetMethodParameterType();
            if (fieldClass.isPrimitive() && attributeValue == null) {
                parameters[parameters.length - 1] = ConversionManager.getDefaultManager().convertObject(0, fieldClass);
                PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), domainObject, parameters), ex -> DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), null, ex));
            }
            throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, exception);
        }
        catch (Exception ex2) {
            throw new RuntimeException(String.format("Invocation of %s setter method failed", this.getSetMethod().getName()), ex2);
        }
    }

    protected void setGetMethod(Method getMethod) {
        this.getMethod = getMethod;
    }

    public void setGetMethodName(String getMethodName) {
        this.getMethodName = getMethodName;
    }

    protected void setSetMethod(Method setMethod) {
        this.setMethod = setMethod;
    }

    public void setSetMethodName(String setMethodName) {
        this.setMethodName = setMethodName;
    }
}

