/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity.table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.table.TableLikeEntity;

public class GenericTableEntity
extends TableLikeEntity {
    public static final String FORMAT_KEY = "format";
    public static final String DOC_KEY = "doc";

    public GenericTableEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
    }

    public static GenericTableEntity of(PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new GenericTableEntity(sourceEntity);
        }
        return null;
    }

    @JsonIgnore
    public String getFormat() {
        return this.getInternalPropertiesAsMap().get(FORMAT_KEY);
    }

    @JsonIgnore
    public String getDoc() {
        return this.getInternalPropertiesAsMap().get(DOC_KEY);
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<GenericTableEntity, Builder> {
        public Builder(TableIdentifier tableIdentifier, String format) {
            this.setType(PolarisEntityType.TABLE_LIKE);
            this.setSubType(PolarisEntitySubType.GENERIC_TABLE);
            this.setTableIdentifier(tableIdentifier);
            this.setFormat(format);
        }

        public Builder setFormat(String format) {
            this.internalProperties.put(GenericTableEntity.FORMAT_KEY, format);
            return this;
        }

        public Builder setDoc(String doc) {
            this.internalProperties.put(GenericTableEntity.DOC_KEY, doc);
            return this;
        }

        public Builder setTableIdentifier(TableIdentifier identifier) {
            Namespace namespace = identifier.namespace();
            this.setParentNamespace(namespace);
            this.setName(identifier.name());
            return this;
        }

        public Builder setParentNamespace(Namespace namespace) {
            if (namespace != null && !namespace.isEmpty()) {
                this.internalProperties.put("parent-namespace", RESTUtil.encodeNamespace((Namespace)namespace));
            }
            return this;
        }

        @Override
        public GenericTableEntity build() {
            return new GenericTableEntity(this.buildBase());
        }
    }
}

