/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.core.FailureContext;
import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.faulttolerance.core.invocation.NormalMethodInvoker;
import io.smallrye.faulttolerance.core.invocation.SpecialMethodInvoker;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;

public final class BeforeRetryMethod {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final Method method;

    BeforeRetryMethod(Method method) {
        this.method = method;
    }

    public Invoker<?> createInvoker(FailureContext ctx) throws ReflectiveOperationException {
        InvocationContext invocationContext = (InvocationContext)ctx.context.get(InvocationContext.class);
        Object[] arguments = invocationContext.getParameters();
        if (arguments == null) {
            arguments = EMPTY_ARRAY;
        }
        return this.method.isDefault() ? new SpecialMethodInvoker(this.method, invocationContext.getTarget(), arguments) : new NormalMethodInvoker(this.method, invocationContext.getTarget(), arguments);
    }

    public static BeforeRetryMethod create(FaultToleranceOperation operation) {
        Method beforeRetryMethod = operation.getBeforeRetryMethod();
        return beforeRetryMethod != null ? new BeforeRetryMethod(beforeRetryMethod) : null;
    }
}

