/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.invocation.AsyncSupportRegistry;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.internal.BeforeRetryMethod;
import io.smallrye.faulttolerance.internal.FallbackMethodCandidates;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Singleton
public class StrategyCache {
    private final Map<InterceptionPoint, FaultToleranceStrategy<?>> strategies = new ConcurrentHashMap();
    private final Map<InterceptionPoint, FallbackMethodCandidates> fallbackMethods = new ConcurrentHashMap<InterceptionPoint, FallbackMethodCandidates>();
    private final Map<InterceptionPoint, BeforeRetryMethod> beforeRetryMethods = new ConcurrentHashMap<InterceptionPoint, BeforeRetryMethod>();
    private final Map<InterceptionPoint, AsyncSupport<?, ?>> asyncSupports = new ConcurrentHashMap();
    private final Map<InterceptionPoint, FallbackFunction<?>> fallbackFunctions = new ConcurrentHashMap();
    private final Map<InterceptionPoint, ExceptionDecision> fallbackExceptionDecisions = new ConcurrentHashMap<InterceptionPoint, ExceptionDecision>();
    private final SpecCompatibility specCompatibility;

    @Inject
    public StrategyCache(SpecCompatibility specCompatibility) {
        this.specCompatibility = specCompatibility;
    }

    public <V> FaultToleranceStrategy<V> getStrategy(InterceptionPoint point, Supplier<FaultToleranceStrategy<V>> producer) {
        return this.strategies.computeIfAbsent(point, ignored -> (FaultToleranceStrategy)producer.get());
    }

    public FallbackMethodCandidates getFallbackMethodCandidates(InterceptionPoint point, FaultToleranceOperation operation) {
        return this.fallbackMethods.computeIfAbsent(point, ignored -> FallbackMethodCandidates.create(operation, this.specCompatibility.allowFallbackMethodExceptionParameter()));
    }

    public BeforeRetryMethod getBeforeRetryMethod(InterceptionPoint point, FaultToleranceOperation operation) {
        return this.beforeRetryMethods.computeIfAbsent(point, ignored -> BeforeRetryMethod.create(operation));
    }

    public <V, AT> AsyncSupport<V, AT> getAsyncSupport(InterceptionPoint point, FaultToleranceOperation operation) {
        AsyncSupport asyncSupport = this.asyncSupports.computeIfAbsent(point, ignored -> AsyncSupportRegistry.get((Class[])operation.getParameterTypes(), operation.getReturnType()));
        return asyncSupport;
    }

    public <V> FallbackFunction<V> getFallbackFunction(InterceptionPoint point, Supplier<FallbackFunction<V>> producer) {
        return this.fallbackFunctions.computeIfAbsent(point, ignored -> (FallbackFunction)producer.get());
    }

    public ExceptionDecision getFallbackExceptionDecision(InterceptionPoint point, Supplier<ExceptionDecision> producer) {
        return this.fallbackExceptionDecisions.computeIfAbsent(point, ignored -> (ExceptionDecision)producer.get());
    }
}

